﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace bsdsocket { namespace cfg {

class Arp
{
    public:

    static Result AddStaticArpEntry(nn::socket::InAddr ipAddress, const uint8_t* pInputHardwareAddress, size_t hardwareAddressSize);

    static Result RemoveArpEntry(nn::socket::InAddr ipAddress);

    static Result LookupArpEntry(uint8_t* pOutputHardwareAddress, size_t hardwareAddressSize, nn::socket::InAddr ipAddress);

    static Result LookupArpEntry(nn::socket::InAddr* pOutputIpAddress, size_t ipAddressSize, const uint8_t* pHardwareAddress, size_t hardwareAddressSize);

    static Result ClearArpEntries();

    static Result ClearArpEntries(const char * pIfName);

    static Result PrintArpEntries();
};

} // namespace cfg
} // namespace bsdsocket
} // namespace nn
