﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KWorkerTask.h"
#include "kern_KThread.h"
#include "kern_KEvent.h"
#include "kern_KSpinLockMutex.h"

namespace nn { namespace kern {

    /*! @file
        @brief      タスクマネージャー クラスの定義です。

        ワーカータスクマネージャーは、スレッド生成のコストを節約しつつ
        作業スレッドを生成する手法を提供します。

    */
    class KWorkThreadManager
    {
    public:
        /*!
          @brief     タスクマネージャーのカテゴリーです。

        */
        enum WorkThreads
        {
            LOW_PRIO_WORK_THREAD,  //!< 通常の優先度のマネージャー (優先度:11)
            WORK_THREAD_COUNT      //!< マネージャー数
        };

    private:
        Bit32           m_Id;        //!< enum WorkThreads の値
        KWorkerTask*    m_pTaskHead; //!< タスクリストの先頭
        KWorkerTask*    m_pTaskTail; //!< タスクリストの最後尾
        bool            m_IsActive;
        KThread*        m_pThread; //!< ワーカースレッド

    public:
        /*!
            @brief     タスクマネージャーを初期化します
            @param[in]    id     タスクマネージャーのカテゴリー(enum WorkThreads)
            @param[in]    priority     ワーカースレッドの優先度(Threadの優先度)

        */
        void Initialize(Bit32 id, int32_t priority);

        /*!
            @brief     タスクを追加します
            @param[in]    id     タスクマネージャーのカテゴリー(enum WorkThreads)
            @param[in]    pTask     追加対象のタスク

        */
        static void AddTask(Bit32 id, KWorkerTask* pTask);

    private:
        //! タスク リンクリストの先頭からひとつタスクを取得します
        KWorkerTask* GetTask();
        //! タスクを処理し続けます。
        void WorkThreadBody();
        //! タスクリストの最後尾にタスクを追加します
        void AddTask(KWorkerTask* pTask);

        //! スレッドのエントリーポイント
        static void WorkThread(uintptr_t param);
    };
}}

