﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Cpu.h>
#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

#if defined NN_SDK_BUILD_DEVELOP || defined NN_SDK_BUILD_DEBUG
#define NN_KERN_STACK_FILL_PATTERN
#define NN_KERN_ENABLE_DUMP_PAGETABLE
#define NN_KERN_ENABLE_USER_PRINT
#define NN_KERN_RECORD_RESOURCE_USAGE
#define NN_KERN_CHECK_KERNEL_STACK

#elif defined NN_SDK_BUILD_RELEASE
//#define NN_KERN_RECORD_RESOURCE_USAGE
//#define NN_KERN_CHECK_KERNEL_STACK

#else
    #error not implemented
#endif

#define NN_KERN_LOG_CPU_UTILIZATION
// #define NN_KERN_CORE_UTILIZATION
// #define NN_KERN_ENABLE_KTRACE
// #define NN_KERN_ENABLE_KERNEL_TRACE
// #define NN_KERN_CHECK_IPC_BOUNDARY

//#define NN_KERN_ENABLE_PERFORMANCE_COUNTER
//#define NN_KERN_ENABLE_IPC_PROFILE
//#define NN_KERN_ENABLE_SVC_PROFILE
//#define NN_KERN_ENABLE_SWITCH_PROFILE
//#define NN_KERN_ENABLE_INTERRUPT_PROFILE


#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
#define NN_KERN_ENABLE_NX_PROFILER
#endif

#if defined(NN_BUILD_CONFIG_CPU_CORTEX_A9)  || \
    defined(NN_BUILD_CONFIG_CPU_CORTEX_A15) || \
    defined(NN_BUILD_CONFIG_CPU_CORTEX_A7)  || \
    defined(NN_BUILD_CONFIG_CPU_CORTEX_A53_AARCH64) || \
    defined(NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH64) || \
    defined(NN_TEST_CONFIG_SVC)

    #define NN_KERN_HAS_MMU                 1
    #define NN_KERN_MULTI_CORE              1
    #define NN_KERN_DEFERED_ARRANGE         1
    #define NN_KERN_MULTI_PROCESS           1

#else
    #error not implemented
#endif

#define NN_KERN_ENABLE_OBJECT_INFO          0

#ifndef NN_SWITCH_DISABLE_DEBUG_PRINT
    #undef  NN_KERN_ENABLE_OBJECT_INFO
    #define NN_KERN_ENABLE_OBJECT_INFO      1
#endif


#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#if defined(NN_BUILD_CONFIG_CPU_ARM_V7A) || defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    static const size_t NN_KERN_FINEST_PAGE_SHIFT                   = 12;

#if defined(NN_BUILD_CONFIG_CPU_ARM_V7A)
    static const size_t NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT         = (NN_KERN_FINEST_PAGE_SHIFT + 0);  // 4K
#elif defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    static const size_t NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT         = (NN_KERN_FINEST_PAGE_SHIFT + 0);  // 4K
#else
#error not defined NN_BUILD_CONFIG_CPU_ARM_
#endif

    static const size_t NN_KERN_FINEST_PAGE_SIZE                    = 1 << NN_KERN_FINEST_PAGE_SHIFT;
    static const size_t NN_KERN_PROCESS_MAIN_THREAD_STACK_NUM_PAGE  = 4;
    static const size_t NN_KERN_THREAD_SVC_STACK_SIZE               = 1 << NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT;
    static const size_t NN_KERN_THREAD_SVC_STACK_NUM_PAGE           = (NN_KERN_THREAD_SVC_STACK_SIZE / NN_KERN_FINEST_PAGE_SIZE);
    static const int NN_KERN_HANDLE_TABLE_SIZE                  = 1024;

    // AutoObject
    static const int NN_KERN_SLAB_OBJ_NUM_EVENT                 =   600;
    static const int NN_KERN_SLAB_OBJ_NUM_INTERRUPT_EVENT       =   100;
    static const int NN_KERN_SLAB_OBJ_NUM_THREAD                =   800;
    static const int NN_KERN_SLAB_OBJ_NUM_SHARED_MEMORY         =    80;
    static const int NN_KERN_SLAB_OBJ_NUM_TRANSFER_MEMORY       =   200;
    static const int NN_KERN_SLAB_OBJ_NUM_CODE_MEMORY           =    10;
    static const int NN_KERN_SLAB_OBJ_NUM_DEVICE_ADDRESS_SPACE  =   300;
    static const int NN_KERN_SLAB_OBJ_NUM_SESSION               =   800;
    static const int NN_KERN_SLAB_OBJ_NUM_PROCESS               =    80;
    static const int NN_KERN_SLAB_OBJ_NUM_PORT                  =   256;
    static const int NN_KERN_SLAB_OBJ_NUM_DMA_OBJECT            =     0;
    static const int NN_KERN_SLAB_OBJ_NUM_DEBUG                 =     4;

    static const int NN_KERN_SLAB_OBJ_NUM_BLOCK_INFO            =  4000;
    static const int NN_KERN_SLAB_OBJ_NUM_APP_MEMORY_BLOCK      = 20000;
    static const int NN_KERN_SLAB_OBJ_NUM_SYS_MEMORY_BLOCK      = 10000;
    static const int NN_KERN_SLAB_OBJ_NUM_THREAD_LOCAL_PAGE     =  (NN_KERN_SLAB_OBJ_NUM_THREAD + NN_KERN_SLAB_OBJ_NUM_PROCESS) / 8 + NN_KERN_SLAB_OBJ_NUM_PROCESS;
    static const int NN_KERN_SLAB_OBJ_NUM_OBJECT_NAME           =     7;
    static const int NN_KERN_SLAB_OBJ_NUM_DEBUG_EVENT_OBJECT    =  NN_KERN_SLAB_OBJ_NUM_DEBUG + NN_KERN_SLAB_OBJ_NUM_THREAD;
    static const int NN_KERN_SLAB_OBJ_NUM_SESSION_REQUEST       =  NN_KERN_SLAB_OBJ_NUM_SESSION * 2;
    static const int NN_KERN_SLAB_OBJ_NUM_LIGHT_SESSION         =   100;
    static const int NN_KERN_SLAB_OBJ_NUM_RESOURCE_LIMIT        =     5;
    static const int NN_KERN_SLAB_OBJ_NUM_SHARED_MEMORY_INFO    =  NN_KERN_SLAB_OBJ_NUM_SHARED_MEMORY * 8;
    static const int NN_KERN_SLAB_OBJ_NUM_PAGE_BUFFER           =  NN_KERN_SLAB_OBJ_NUM_THREAD + NN_KERN_SLAB_OBJ_NUM_THREAD_LOCAL_PAGE;
    static const int NN_KERN_SLAB_OBJ_NUM_INTERRUPT_EVENT_TASK  =  NN_KERN_SLAB_OBJ_NUM_INTERRUPT_EVENT;

    static const int NN_KERN_SLAB_OBJ_NUM_LINKED_LIST_NODE      =
    // KLockWithPriorityInheritance の競合
    NN_KERN_SLAB_OBJ_NUM_THREAD +
    // KSynchronizationObject (スレッド数 x 同時待ち / 2)
    NN_KERN_SLAB_OBJ_NUM_THREAD * 16;
#else
#error Unsupported processor
#endif
#endif // #ifndef NN_SWITCH_INCLUDE_FROM_NON_C

#if defined NN_KERN_ENABLE_KTRACE
#define NN_KERN_KTRACE_BUFFER_SIZE      0x10000000
#else
#define NN_KERN_KTRACE_BUFFER_SIZE      0
#endif
#if defined NN_KERN_ENABLE_KERNEL_TRACE
#define NN_KERN_TRACE_BUFFER_SIZE       0x01000000
#else
#define NN_KERN_TRACE_BUFFER_SIZE       0
#endif

