﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace kern {

    /*! @file
        @brief      KWorkerTask クラスの定義

        ワーカータスクは、スレッド生成のコストを節約しつつ作業スレッドを生成する
        手法を提供します。KWorkThreadManagerにAddTaskすることで、プリセット済みの
        スレッド優先度で DoTask() メンバー関数が非同期的に呼び出されることを期待できます。
    */

    class KWorkerTask
    {
    public:
        /*!
            @brief     コンストラクタ。

        */
        KWorkerTask() : m_pNextTask(NULL) {}

        /*!
            @brief     次のタスクを登録します。

            この関数はKWorkThreadManagerからのみ呼び出されるべきです。
        */
        void            SetNextTask(KWorkerTask* pTask) { m_pNextTask = pTask; }
        /*!
            @brief     次のタスクを取得します。

            この関数はKWorkThreadManagerからのみ呼び出されるべきです。
        */
        KWorkerTask*    GetNextTask()                   { return m_pNextTask; }

        /*!
            @brief     ワーカータスクのエントリーポイント

            継承クラスでこの関数をオーバーライドします。
            DoTaskが呼び出された時点で KWorkThreadManager からの管理は手放されています。
        */
        virtual void DoTask() = 0;

    private:
        //! 次のタスクへのポインタです。
        KWorkerTask*      m_pNextTask;
    };

}}

