﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Assert.h"
#include "kern_KSlabAllocator.h"

namespace nn { namespace kern {

template <class _Derived>
class KUseSlabAllocator
{
public:
    static void InitializeSlab(void* pMem, size_t memSize)
    {
        s_SlabAllocator.Initialize(pMem, memSize);
    }

    static _Derived* Allocate()
    {
        return s_SlabAllocator.AllocateFromSlab();
    }
    static void Free(_Derived* pObj)
    {
        s_SlabAllocator.FreeToSlab(pObj);
    }
    static size_t GetSlabSize()             { return s_SlabAllocator.GetSlabSize(); }
    static size_t GetObjSize()              { return s_SlabAllocator.GetObjSize(); }
    static size_t GetNumRemain()            { return s_SlabAllocator.GetNumRemain(); }
    static size_t GetPeakNum()              { return s_SlabAllocator.GetPeakNum(); }
    static size_t GetIndex(const _Derived* pObj) { return s_SlabAllocator.GetIndex(pObj); }
    static uintptr_t GetSlabAddr()          { return s_SlabAllocator.GetSlabAddr(); }

private:
    static KSlabAllocator<_Derived> s_SlabAllocator;
};

}}

