﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include "kern_Assert.h"
#include "kern_KUseSlabAllocator.h"

namespace nn { namespace kern {

class KSharedMemory;
class KSharedMemoryInfo :
    public KUseSlabAllocator<KSharedMemoryInfo>,
    public nn::util::IntrusiveListBaseNode<KSharedMemoryInfo>
{
public:
    KSharedMemoryInfo(){}
    ~KSharedMemoryInfo(){}

    void Initialize(KSharedMemory* pSharedMemory)
    {
        NN_KERN_THIS_ASSERT();
        m_pSharedMemory = pSharedMemory;
        m_ReferenceCount = 0;
    }

    void Open()
    {
        m_ReferenceCount++;
    }

    bool Close()
    {
        return (--m_ReferenceCount == 0);
    }

    KSharedMemory* GetSharedMemory() const { return m_pSharedMemory; }
    size_t         GetReferenceCount() const { return m_ReferenceCount; }
private:
    KSharedMemory*      m_pSharedMemory;
    size_t              m_ReferenceCount;
};

}}

