﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief イベントに関する API の宣言

*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Assert.h"
#include "kern_KSynchronizationObject.h"

namespace nn { namespace kern {

class KEvent;

/*!
  @brief      イベント クラスの定義です。
*/
class KReadableEvent :
    public KSynchronizationObject
{
private:
    bool                m_Signaled;         //!< イベントがシグナル状態になったか
    KEvent*             m_pParentEvent;

public:
    explicit KReadableEvent() {}
    virtual ~KReadableEvent() {}
    void  Initialize(KEvent* pParentEvent);
    KEvent* GetParent() const { return m_pParentEvent; }

    virtual Result Signal();
    virtual Result Clear();
    virtual Result Reset();

    // override KSynchronizationObject
    virtual bool IsSignaled() const;
    virtual void Destroy();

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KReadableEvent, KSynchronizationObject)
};

}}

