﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_Assert.h"
#include "kern_KUseSlabAllocator.h"
#include "kern_KMemoryLayout.h"
#include <cstring>

namespace nn { namespace kern {

class KPageBuffer :
    public KUseSlabAllocator<KPageBuffer>
{
public:
    KPageBuffer()
    {
        std::memset(m_Buffer, 0, sizeof(m_Buffer));
    }
    ~KPageBuffer(){}
    KPhysicalAddress GetPhysicalAddress() const
    {
        KPhysicalAddress physAddr = KPhysicalAddress(KMemoryLayout::GetSlabRegionPhysicalBegin() + (reinterpret_cast<uintptr_t>(this) - GetAsInteger(KMemoryLayout::GetSlabRegionBegin())));
        return physAddr;
    }
    static KPageBuffer* FromPhysicalAddress(KPhysicalAddress physAddr)
    {
        NN_KERN_ABORT_UNLESS(KMemoryLayout::InSlabRegionPhysical(physAddr));
        return GetTypedPointer<KPageBuffer>(KMemoryLayout::GetSlabRegionBegin() + (physAddr - KMemoryLayout::GetSlabRegionPhysicalBegin()));
    }

private:
    NN_ALIGNAS(NN_KERN_FINEST_PAGE_SIZE) char m_Buffer[NN_KERN_FINEST_PAGE_SIZE] NN_IS_UNUSED_MEMBER;
};
static_assert( sizeof(KPageBuffer) == NN_KERN_FINEST_PAGE_SIZE, "" );

}}

