﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_Assert.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KAutoObject.h"
#include "kern_KThread.h"

namespace nn { namespace kern {

class KLightSession;

class KLightClientSession :
    public KObjectAdaptor<KLightClientSession, KAutoObjectWithList>
{
private:
    KLightSession*  m_pParent;

public:
    explicit        KLightClientSession()  {}
    virtual         ~KLightClientSession() {}

    void  Initialize(KLightSession* p)
    {
        NN_KERN_THIS_ASSERT();
        m_pParent = p;
    }

    virtual void    Destroy();
    static void     PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    Result          SendRequest(Bit32* pData);
    Result          CancelSyncRequest();
    KLightSession*  GetParent()                     { return m_pParent; }
    void            OnServerClosed();

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KLightClientSession, KAutoObject)
};

}}

