﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KLightClientSession.h"
#include "kern_KLightSession.h"
#include "kern_KThread.h"
#include "kern_KProcess.h"
#include "kern_KScheduler.h"
#include "kern_KSession.h"
#include "kern_KScopedSchedulingLock.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KLightClientSession);

void KLightClientSession::Destroy()
{
    NN_KERN_THIS_ASSERT();
    //! クライアントセッションが閉じたことをセッションに通知します
    m_pParent->OnClientClosed();
    // このタイミングで既に this が破棄されている可能性があるので
    // 以降、this にアクセスしてはいけない。
}

//! ペアとなるサーバーセッションが閉じたことの通知
void KLightClientSession::OnServerClosed()
{
    NN_KERN_THIS_ASSERT();
}

//! サーバーセッションに対して同期リクエストする
nn::Result KLightClientSession::SendRequest(Bit32* pData)
{
    NN_KERN_THIS_ASSERT();
    Result result;
    KThread* pRequestSource = &GetCurrentThread();
    pRequestSource->SetLightSessionData(pData);
    {
        KScopedSchedulingLock locker;

        pRequestSource->SetSyncedObject(NULL, ResultSuccess());

        result = m_pParent->OnRequest(pRequestSource);
        // 寝る
    }

    if (result.IsFailure())
    {
        return result;
    }

    KSynchronizationObject* pSyncedObj;
    result = GetCurrentThread().GetWaitResult(&pSyncedObj);

    return result;
}

}}
