﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KTaggedAddress.h"

namespace nn { namespace kern {

    struct KHeapArrange
    {
        KVirtualAddress managementAddr;
        size_t          managementSize;
        KVirtualAddress secureSystemAddr;
        size_t          secureSystemSize;
        KVirtualAddress nonSecureSystemAddr;
        size_t          nonSecureSystemSize;
        KVirtualAddress appletAddr;
        size_t          appletSize;
        KVirtualAddress applicationAddr;
        size_t          applicationSize;

        KVirtualAddress secureSystemBackAddr;
        KVirtualAddress nonSecureSystemBackAddr;
        KVirtualAddress appletBackAddr;
        KVirtualAddress applicationBackAddr;
    };

}}
