﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_Assert.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KAutoObject.h"
#include "kern_KThread.h"
#include "kern_KWritableEvent.h"

namespace nn { namespace kern {

class KSession;

class KClientSession :
    public KObjectAdaptor<KClientSession, KAutoObjectWithList>
{
private:
    KSession*       m_pParent;    //!< クライアントとサーバーの間を取り持つセッション

public:
    explicit        KClientSession()  {}
    virtual         ~KClientSession() {}

    void            Initialize(KSession* p)
    {
        NN_KERN_THIS_ASSERT();
        m_pParent = p;
    }

    virtual void    Destroy();
    static void     PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    //! サーバーセッションに対して同期リクエストする
    Result          SendSyncRequest(uintptr_t addr, size_t size);
    //! サーバーセッションに対して非同期リクエストする (未実装)
    Result          SendAsyncRequest(KWritableEvent* pEvent, uintptr_t addr, size_t size);
    //! 同期リクエストをキャンセルする
    Result          CancelSyncRequest();
    //!< クライアントとサーバーの間を取り持つセッションを取得します
    KSession*       GetParent() const { return m_pParent; }

    //! ペアとなるサーバーセッションが閉じたことの通知
    void            OnServerClosed();

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KClientSession, KAutoObject)
};

}}

