﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KAffinityMask.h"

namespace nn { namespace kern {

/*!
    @brief      対象のコアの Affinity を取得します。

*/
bool KAffinityMask::GetAffinity(int32_t core) const
{
    NN_KERN_THIS_ASSERT();
    NN_KERN_ASSERT(0 <= core && core < KCPU::NUM_CORE);
    return m_Mask & (static_cast<Bit64>(1) << core);
}

/*!
    @brief      対象のコアの Affinity を設定します。

*/
void KAffinityMask::SetAffinity(int32_t core, bool affinity)
{
    NN_KERN_THIS_ASSERT();
    NN_KERN_ASSERT(0 <= core && core < KCPU::NUM_CORE);
    if (affinity)
    {
        m_Mask |= (static_cast<Bit64>(1) << core);
    }
    else
    {
        m_Mask &= ~(static_cast<Bit64>(1) << core);
    }
}

/*!
    @brief      すべてのコアの Affinity を有効にします。

*/
void KAffinityMask::SetAll()
{
    NN_KERN_THIS_ASSERT();
    m_Mask = ((static_cast<Bit64>(1) << KCPU::NUM_CORE) - 1);
}

}}
