﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief 初期プロセスに関する API の宣言

*/

#pragma once

#include <nn/nn_BitTypes.h>
#include "kern_KTaggedAddress.h"


namespace nn { namespace kern {

        struct InitialProcessImageHeader
        {
            uint32_t    signature;              // ファイル署名 "INI1"
            uint32_t    totalLength;            // INITIAL_PROCESS イメージ のバイトサイズ
            uint32_t    numInitialProcesses;    // 含まれる .kip の個数
            uint32_t    padding;
        };

        const uint32_t InitialProcessImageHeaderValidSignature = 0x31494e49;

        /*!
            @brief     メインメモリに初期プロセスのイメージをコピーします。

        */
        size_t CopyProcessImagesToMainMemory();

        /*!
            @brief     メインメモリ上のプロセスをロードして実行します。

        */
        void    LoadAndRunProcessesFromMainMemory();

        /*!
            @brief     初期プロセス数を返します。

        */
        uint32_t     GetNumOfInitialProcesses();

        size_t GetInitialProcessesNonSecureMemorySize();
        Bit64 GetInitialProcessIdMin();
        Bit64 GetInitialProcessIdMax();
}}

