﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#include "kern_Platform.h"
#endif

#ifndef NN_KERN_CALC_END
#define NN_KERN_CALC_END(name)      ((name) + (name ## _SIZE))
#define NN_KERN_CALC_SIZE(name)     ((name ## _END) - (name))
#define NN_KERN_CALC_HEAD(name)     ((name ## _END) - (name ## _SIZE))
#endif

#ifndef NN_KERN_UL
#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ull
#endif
#endif

//---------------------------------------------------------------------------
// ページテーブル関連
// T0 = 32bit process address space size: 32bit
// T0 = 64bit process address space size: 36bit or 39bit
// T1 = kernel address space size: 39bit
#define NN_KERN_DETAIL_T0_32BIT_SPACE_SHIFT             32
#define NN_KERN_DETAIL_T0_36BIT_SPACE_SHIFT             36
#define NN_KERN_DETAIL_T0_39BIT_SPACE_SHIFT             39
#define NN_KERN_DETAIL_T1_SPACE_SHIFT                   39
#define NN_KERN_DETAIL_MMU_L1_PAGE_TABLE_1_SIZE         ((NN_KERN_UL(1) << NN_KERN_DETAIL_T1_SPACE_SHIFT) / 0x40000000 * 8)

#define NN_KERN_DETAIL_ASLR_SHIFT                       21      // 2MB
#define NN_KERN_DETAIL_ASLR_ALIGN                       (NN_KERN_UL(1) << NN_KERN_DETAIL_ASLR_SHIFT)
#define NN_KERN_DETAIL_HEAP_ALIGN                       NN_KERN_UL(0x00200000)
#define NN_KERN_DETAIL_ALIGNUP(x, align)                (((x) + (align) - 1) & ~((align) - 1))
#define NN_KERN_DETAIL_ALIGNDOWN(x, align)              ((x) & ~((align) - 1))

//---------------------------------------------------------------------------
// 物理アドレス
#define NN_KERN_DETAIL_P_ADDR_CODE                      (NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY + NN_KERN_DETAIL_P_ADDR_RESERVED_LO_SIZE)
#define NN_KERN_DETAIL_P_ADDR_CODE_REQ_SIZE             NN_KERN_UL(0x00200000)
#define NN_KERN_DETAIL_P_ADDR_CODE_END                  NN_KERN_DETAIL_ALIGNUP(NN_KERN_DETAIL_P_ADDR_CODE + NN_KERN_DETAIL_P_ADDR_CODE_REQ_SIZE, NN_KERN_DETAIL_HEAP_ALIGN)

#define NN_KERN_DETAIL_P_ADDR_CODE_ASLR                 NN_KERN_DETAIL_ALIGNDOWN(NN_KERN_DETAIL_P_ADDR_CODE, NN_KERN_DETAIL_ASLR_ALIGN)


#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
extern "C" char __ex_start[];
extern "C" char __ex_end[];
extern "C" char __ro_start[];
extern "C" char __ro_end[];
extern "C" char __rw_start[];
extern "C" char __rw_end[];
extern "C" char __bss_start[];
extern "C" char __bss_end[];
extern "C" char __slab_pt_start[];
extern "C" char __slab_pt_end[];
#endif

#define NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP              (NN_KERN_DETAIL_P_ADDR_CODE + __slab_pt_start - __ex_start)
#define NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP_SIZE         NN_KERN_UL(0x01b00000)
#define NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP_END          (NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP + NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP_SIZE)

#define NN_KERN_DETAIL_P_ADDR_SLAB_RESERVED_SIZE        NN_KERN_UL(0x00200000)

#define NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS_SIZE      NN_KERN_UL(0x00c00000)
#define NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS_DEST      (NN_KERN_DETAIL_P_ADDR_SLAB_PT_HEAP_END - NN_KERN_DETAIL_P_ADDR_INITIAL_PROCESS_SIZE)


// 仮想アドレス
#define NN_KERN_DETAIL_V_ADDR_KERNEL                    (NN_KERN_UL(0) - (NN_KERN_UL(1) << NN_KERN_DETAIL_T1_SPACE_SHIFT))
#define NN_KERN_DETAIL_V_ADDR_KERNEL_SIZE               (NN_KERN_DETAIL_V_ADDR_KERNEL_END - NN_KERN_DETAIL_V_ADDR_KERNEL)
#define NN_KERN_DETAIL_V_ADDR_KERNEL_END                (NN_KERN_UL(0) - NN_KERN_DETAIL_ASLR_ALIGN)

#define NN_KERN_DETAIL_V_ADDR_MISC_SIZE                 NN_KERN_DETAIL_ALIGNUP(NN_KERN_UL(0x02000000), NN_KERN_DETAIL_ASLR_ALIGN)
#define NN_KERN_DETAIL_V_ADDR_STACK_REGION_SIZE         NN_KERN_DETAIL_ALIGNUP(NN_KERN_UL(NN_KERN_SLAB_OBJ_NUM_THREAD * NN_KERN_THREAD_SVC_STACK_SIZE * 4), NN_KERN_DETAIL_ASLR_ALIGN)
#define NN_KERN_DETAIL_V_ADDR_TEMP_SIZE                 NN_KERN_DETAIL_ALIGNUP(NN_KERN_UL(0x08000000), NN_KERN_DETAIL_ASLR_ALIGN)

#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_EX              (reinterpret_cast<uintptr_t>(__ex_start))
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_EX_SIZE         (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_EX_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_EX)
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_EX_END          (reinterpret_cast<uintptr_t>(__ex_end))

#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO              (reinterpret_cast<uintptr_t>(__ro_start))
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_SIZE         (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO)
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RO_END          (reinterpret_cast<uintptr_t>(__ro_end))

#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW              (reinterpret_cast<uintptr_t>(__rw_start))
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_SIZE         (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW)
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_RW_END          (reinterpret_cast<uintptr_t>(__rw_end))

#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI              (reinterpret_cast<uintptr_t>(__bss_start))
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_SIZE         (NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_END - NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI)
#define NN_KERN_DETAIL_V_ADDR_CODE_MAIN_ZI_END          (reinterpret_cast<uintptr_t>(__bss_end))


#define NN_KERN_DETAIL_V_ADDR_CORE_LOCAL_REGION_SIZE    NN_KERN_FINEST_PAGE_SIZE
