﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../../../kern_Platform.h"
#include "../../../kern_Panic.h"
#include "../../../kern_KThread.h"
#include "../../../kern_DpcManager.h"
#include "../../../kern_KProcess.h"
#include "../../../kern_KTrace.h"
#include "../../../kern_Trace.h"

namespace nn { namespace kern { namespace svc {

void InvalidSvcIdHandler(int svcId,  uintptr_t addr)
{
    NN_UNUSED(svcId);
    NN_UNUSED(addr);
    NN_KERNEL_PANIC("invalid svc id %d caller=%p\n", svcId, addr);
}
void DpcHandler()
{
    NN_KERN_ASSERT(!KInterruptManager::IsInterruptEnabled());
    DpcManager::DpcHandler();
}

extern "C" void SvcEnterDump32(Bit64 *reg, Bit64 esr)
{
    NN_UNUSED(reg);
    NN_UNUSED(esr);
    NN_LOG("SWI Enter\n", esr);
    NN_LOG("    ESR%p\n", esr);
    NN_LOG("    SP=%p\n", reg);
    for (int i = 0; i < 14; i++)
    {
        NN_LOG("    x%d=%p\n",i,*reg++);
    }
}
extern "C" void SvcLeaveDump32(Bit64 *reg, Bit64 esr)
{
    NN_UNUSED(reg);
    NN_UNUSED(esr);
    NN_LOG("SWI Leave\n", esr);
    NN_LOG("    ESR%p\n", esr);
    NN_LOG("    SP=%p\n", reg);
    for (int i = 0; i < 14; i++)
    {
        NN_LOG("    x%d=%p\n",i,*reg++);
    }
}
extern "C" void SvcEnterDump64(Bit64 *reg, Bit64 esr)
{
    NN_UNUSED(reg);
    NN_UNUSED(esr);
    NN_LOG("SWI Enter\n", esr);
    NN_LOG("    ESR%p\n", esr);
    NN_LOG("    SP=%p\n", reg);
    for (int i = 0; i < 8; i++)
    {
        NN_LOG("    x%d=%p\n",i,*reg++);
    }
}
extern "C" void SvcLeaveDump64(Bit64 *reg, Bit64 esr)
{
    NN_UNUSED(reg);
    NN_UNUSED(esr);
    NN_LOG("SWI Leave\n", esr);
    NN_LOG("    ESR%p\n", esr);
    NN_LOG("    SP=%p\n", reg);
    for (int i = 0; i < 8; i++)
    {
        NN_LOG("    x%d=%p\n",i,*reg++);
    }
}

#if defined NN_KERN_ENABLE_KTRACE || defined NN_KERN_ENABLE_KERNEL_TRACE || defined NN_KERN_ENABLE_SVC_PROFILE
extern "C" void SvcEnterTrace(Bit64 *reg)
{
    NN_UNUSED(reg);
#if defined NN_KERN_ENABLE_SVC_PROFILE
    GetCurrentThread().IncrementNumSvc(GetCurrentThread().GetSvcNo());
#endif
    NN_KERN_KTRACE_SVC_ENTER(GetCurrentThread().GetSvcNo(),
            reg[0], reg[1], reg[2], reg[3], reg[4], reg[5], reg[6], reg[7]);
    NN_KERN_KTRACE_BACKTRACE();
    NN_KERN_TRACE_SYSTEM_CALL_ENTRY(GetCurrentThread().GetSvcNo(), reg);
}

extern "C" void SvcLeaveTrace(Bit64 *reg)
{
    NN_UNUSED(reg);
    NN_KERN_KTRACE_SVC_LEAVE(GetCurrentThread().GetSvcNo(),
            reg[0], reg[1], reg[2], reg[3], reg[4], reg[5], reg[6], reg[7]);
    NN_KERN_TRACE_SYSTEM_CALL_EXIT(GetCurrentThread().GetSvcNo(), reg);
}
#endif

}}}

