﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include "../../../svc/kern_KUserPointer.h"
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_BaseType.h>
#include <nn/svc/svc_DdType.h>
#include <nn/svc/svc_DmntType.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_ServerType.h>
#include <nn/svc/svc_TcbType.h>

#include <nn/svc/svc_BaseType.ilp32.autogen.h>
#include <nn/svc/svc_DdType.ilp32.autogen.h>
#include <nn/svc/svc_DmntType.ilp32.autogen.h>
#include <nn/svc/svc_TcbType.ilp32.autogen.h>

#ifdef __cplusplus

namespace nn {
namespace kern {
namespace svc {

    Result  SvcSetHeapSize64From32                    (uintptr_t* pOut, size_t size);
    Result  SvcSetMemoryPermission64From32            (uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
    Result  SvcSetMemoryAttribute64From32             (uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
    Result  SvcMapMemory64From32                      (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcUnmapMemory64From32                    (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcQueryMemory64From32                    (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
    void    SvcExitProcess64From32                    ();
    Result  SvcCreateThread64From32                   (nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
    Result  SvcStartThread64From32                    (nn::svc::Handle thread);
    void    SvcExitThread64From32                     ();
    void    SvcSleepThread64From32                    (int64_t ns);
    Result  SvcGetThreadPriority64From32              (int32_t* pOut, nn::svc::Handle thread);
    Result  SvcSetThreadPriority64From32              (nn::svc::Handle thread, int32_t priority);
    Result  SvcGetThreadCoreMask64From32              (int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
    Result  SvcSetThreadCoreMask64From32              (nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
    int32_t SvcGetCurrentProcessorNumber64From32      ();
    Result  SvcSignalEvent64From32                    (nn::svc::Handle event);
    Result  SvcClearEvent64From32                     (nn::svc::Handle event);
    Result  SvcMapSharedMemory64From32                (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcUnmapSharedMemory64From32              (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateTransferMemory64From32           (nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcCloseHandle64From32                    (nn::svc::Handle handle);
    Result  SvcResetSignal64From32                    (nn::svc::Handle handle);
    Result  SvcWaitSynchronization64From32            (int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns);
    Result  SvcCancelSynchronization64From32          (nn::svc::Handle handle);
    Result  SvcArbitrateLock64From32                  (nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
    Result  SvcArbitrateUnlock64From32                (uintptr_t addr);
    Result  SvcWaitProcessWideKeyAtomic64From32       (uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
    void    SvcSignalProcessWideKey64From32           (uintptr_t cvKey, int32_t num);
    int64_t SvcGetSystemTick64From32                  ();
    Result  SvcConnectToNamedPort64From32             (nn::svc::Handle* pOut, KUserPointer<const char*> name);
    Result  SvcSendSyncRequestLight64From32           (nn::svc::Handle session);
    Result  SvcSendSyncRequest64From32                (nn::svc::Handle session);
    Result  SvcSendSyncRequestWithUserBuffer64From32  (uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcSendAsyncRequestWithUserBuffer64From32 (nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcGetProcessId64From32                   (nn::Bit64* pOut, nn::svc::Handle process);
    Result  SvcGetThreadId64From32                    (nn::Bit64* pOut, nn::svc::Handle thread);
    void    SvcBreak64From32                          (nn::svc::BreakReason reason, uintptr_t data, size_t length);
    Result  SvcOutputDebugString64From32              (KUserPointer<const char*> text, size_t length);
    void    SvcReturnFromException64From32            (nn::Result result);
    Result  SvcGetInfo64From32                        (nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
    void    SvcFlushEntireDataCache64From32           ();
    Result  SvcFlushDataCache64From32                 (uintptr_t addr, size_t size);
    Result  SvcMapPhysicalMemory64From32              (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemory64From32            (uintptr_t addr, size_t size);
    Result  SvcGetDebugFutureThreadInfo64From32       (nn::svc::ilp32::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns);
    Result  SvcGetLastThreadInfo64From32              (nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
    Result  SvcGetResourceLimitLimitValue64From32     (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcGetResourceLimitCurrentValue64From32   (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcSetThreadActivity64From32              (nn::svc::Handle handle, nn::svc::ThreadActivity activity);
    Result  SvcGetThreadContext364From32              (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle handle);
    Result  SvcWaitForAddress64From32                 (uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
    Result  SvcSignalToAddress64From32                (uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
    void    SvcKernelDebug64From32                    (nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
    void    SvcChangeKernelTraceState64From32         (nn::svc::KernelTraceState state);
    Result  SvcCreateSession64From32                  (nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name);
    Result  SvcAcceptSession64From32                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcReplyAndReceiveLight64From32           (nn::svc::Handle session);
    Result  SvcReplyAndReceive64From32                (int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcReplyAndReceiveWithUserBuffer64From32  (int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcCreateEvent64From32                    (nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle);
    Result  SvcMapPhysicalMemoryUnsafe64From32        (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemoryUnsafe64From32      (uintptr_t addr, size_t size);
    Result  SvcSetUnsafeLimit64From32                 (size_t limitSize);
    Result  SvcCreateCodeMemory64From32               (nn::svc::Handle* pOut, uintptr_t addr, size_t size);
    Result  SvcControlCodeMemory64From32              (nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
    void    SvcSleepSystem64From32                    ();
    Result  SvcReadWriteRegister64From32              (nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
    Result  SvcSetProcessActivity64From32             (nn::svc::Handle handle, nn::svc::ProcessActivity activity);
    Result  SvcCreateSharedMemory64From32             (nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
    Result  SvcMapTransferMemory64From32              (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
    Result  SvcUnmapTransferMemory64From32            (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateInterruptEvent64From32           (nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
    Result  SvcQueryPhysicalAddress64From32           (nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
    Result  SvcQueryIoMapping64From32                 (uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
    Result  SvcCreateDeviceAddressSpace64From32       (nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
    Result  SvcAttachDeviceAddressSpace64From32       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcDetachDeviceAddressSpace64From32       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcMapDeviceAddressSpaceByForce64From32   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpaceAligned64From32   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpace64From32          (size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcUnmapDeviceAddressSpace64From32        (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
    Result  SvcInvalidateProcessDataCache64From32     (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcStoreProcessDataCache64From32          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcFlushProcessDataCache64From32          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcDebugActiveProcess64From32             (nn::svc::Handle* pOut, nn::Bit64 processId);
    Result  SvcBreakDebugProcess64From32              (nn::svc::Handle debug);
    Result  SvcTerminateDebugProcess64From32          (nn::svc::Handle debug);
    Result  SvcGetDebugEvent64From32                  (KUserPointer<nn::svc::ilp32::DebugEventInfo*> pInfo, nn::svc::Handle debug);
    Result  SvcContinueDebugEvent64From32             (nn::svc::Handle debug, nn::Bit32 flags, KUserPointer<const nn::Bit64*> pThreadIds, int32_t arraySize);
    Result  SvcGetProcessList64From32                 (int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize);
    Result  SvcGetThreadList64From32                  (int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain);
    Result  SvcGetDebugThreadContext64From32          (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags);
    Result  SvcSetDebugThreadContext64From32          (nn::svc::Handle debug, nn::Bit64 threadId, KUserPointer<const nn::svc::ThreadContext*> context, nn::Bit32 controlFlags);
    Result  SvcQueryDebugProcessMemory64From32        (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr);
    Result  SvcReadDebugProcessMemory64From32         (uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size);
    Result  SvcWriteDebugProcessMemory64From32        (nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size);
    Result  SvcSetHardwareBreakPoint64From32          (nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value);
    Result  SvcGetDebugThreadParam64From32            (nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select);
    Result  SvcGetSystemInfo64From32                  (nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
    Result  SvcCreatePort64From32                     (nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
    Result  SvcManageNamedPort64From32                (nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions);
    Result  SvcConnectToPort64From32                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcSetProcessMemoryPermission64From32     (nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
    Result  SvcMapProcessMemory64From32               (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcUnmapProcessMemory64From32             (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcQueryProcessMemory64From32             (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
    Result  SvcMapProcessCodeMemory64From32           (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcUnmapProcessCodeMemory64From32         (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcCreateProcess64From32                  (nn::svc::Handle* pOut, KUserPointer<const nn::svc::ilp32::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum);
    Result  SvcStartProcess64From32                   (nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
    Result  SvcTerminateProcess64From32               (nn::svc::Handle process);
    Result  SvcGetProcessInfo64From32                 (int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
    Result  SvcCreateResourceLimit64From32            (nn::svc::Handle* pOut);
    Result  SvcSetResourceLimitLimitValue64From32     (nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
    void    SvcCallSecureMonitor64From32              ();

} // end of namespace svc
} // end of namespace kern
} // end of namespace nn

#endif  // ifdef __cplusplus

