﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */


//
// type name                                size al abstr comon
//
// Handle                                      4  4 True  True 
// ProgramId                                   8  8 True  True 
// MemoryState                                 4  4 True  True 
// MemoryAttribute                             4  4 True  True 
// MemoryPermission                            4  4 True  True 
// InterruptType                               4  4 True  True 
// BreakReason                                 4  4 True  True 
// InfoType                                    4  4 True  True 
// SystemInfoType                              4  4 True  True 
// KernelDebugType                             4  4 True  True 
// LimitableResource                           4  4 True  True 
// ThreadActivity                              4  4 True  True 
// ProcessActivity                             4  4 True  True 
// KernelTraceState                            4  4 True  True 
// CodeMemoryOperation                         4  4 True  True 
// ArbitrationType                             4  4 True  True 
// SignalType                                  4  4 True  True 
// PageInfo                                    4  4 True  True 
// ThreadFunc                                  8  8 True  False
// MemoryInfo                                 40  8 False False
// LastThreadContext                          32  8 False False
// DebugEvent                                  4  4 True  True 
// DebugException                              4  4 True  True 
// ProcessExitReason                           4  4 True  True 
// ThreadExitReason                            4  4 True  True 
// BreakPointType                              4  4 True  True 
// DebugThreadParam                            4  4 True  True 
// HardwareBreakPointRegisterName              4  4 True  True 
// DebugInfoCreateProcess                     40  8 False False
// DebugInfoCreateThread                      24  8 False False
// DebugInfoExitProcess                        4  4 False False
// DebugInfoExitThread                         4  4 False False
// DebugInfoExceptionAccessViolationData       8  8 False False
// DebugInfoExceptionDataTypeMissaligned       8  8 False False
// DebugInfoExceptionBreakPoint               16  8 False False
// DebugInfoExceptionUserBreak                24  8 False False
// DebugInfoExceptionDebuggerBreak            32  8 False False
// DebugInfoExceptionUndefinedInstruction      4  4 False False
// DebugInfoExceptionUndefinedSystemCall       4  4 False False
// DebugInfoExceptionDetail                   32  8 False False
// DebugInfoException                         48  8 False False
// DebugInfo                                  48  8 False False
// DebugEventInfo                             64  8 False False
// ThreadContext                             332  4 True  True 
// DeviceName                                  4  4 True  True 
// PhysicalAddress                             8  8 True  True 
// DMADeviceConfig                            10  2 True  True 
// DmaConfig                                  24  2 True  True 
// PhysicalMemoryInfo                         24  8 False False
// CreateProcessParameterFlags                 4  4 True  True 
// ProcessInfoType                             4  4 True  True 
// CreateProcessParameter                     48  8 False False
//

//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       8 size     Register 1       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv
    .type    _ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv, %function
    .type    _ZN2nn4kern3svc16SvcSetHeapSize64EPmm, %function
_ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcSetHeapSize64EPmm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv, [.-_ZN2nn4kern3svc7Aarch6415CallSetHeapSizeEv]

//-------------------------------------------------
// Result QueryMemory(KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       8 addr         Register 2       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv, %function
    .type    _ZN2nn4kern3svc16SvcQueryMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoEm, %function
_ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcQueryMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoEm

    ldr      x1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv, [.-_ZN2nn4kern3svc7Aarch6415CallQueryMemoryEv]

//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pOut
//     Register 1       8 f             Register 1       8 f
//     Register 2       8 param         Register 2       8 param
//     Register 3       8 stackBottom   Register 3       8 stackBottom
//     Register 4       4 priority      Register 4       4 priority
//     Register 5       4 idealCore     Register 5       4 idealCore
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOut          
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6416CallCreateThreadEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6416CallCreateThreadEv
    .type    _ZN2nn4kern3svc7Aarch6416CallCreateThreadEv, %function
    .type    _ZN2nn4kern3svc17SvcCreateThread64EPNS_3svc6HandleEmmmii, %function
_ZN2nn4kern3svc7Aarch6416CallCreateThreadEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc17SvcCreateThread64EPNS_3svc6HandleEmmmii

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6416CallCreateThreadEv, [.-_ZN2nn4kern3svc7Aarch6416CallCreateThreadEv]

//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv
    .type    _ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv, %function
    .type    _ZN2nn4kern3svc22SvcGetThreadPriority64EPiNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetThreadPriority64EPiNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv, [.-_ZN2nn4kern3svc7Aarch6421CallGetThreadPriorityEv]

//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     Invariant s=8 r=8 p=8              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  4 pIdealCore
//                                        Register 1  ref  8 pAffinityMask
//     Register 2       4 thread          Register 2       4 thread
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pIdealCore      
//     Register 2       8 pAffinityMask   
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv
    .type    _ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv, %function
    .type    _ZN2nn4kern3svc22SvcGetThreadCoreMask64EPiPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pIdealCore の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIdealCore のアドレスをレジスタへ
    str      x2, [sp, #8]              // pAffinityMask の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pAffinityMask のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetThreadCoreMask64EPiPmNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pIdealCore の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pAffinityMask の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv, [.-_ZN2nn4kern3svc7Aarch6421CallGetThreadCoreMaskEv]

//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     Invariant s=8 r=8 p=8             AArch64 s=8 r=8 p=8
// in  svc                               abi
//                                       Register 0  ref  4 pOut
//     Register 1       8 addr           Register 1       8 addr
//     Register 2       8 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv, %function
    .type    _ZN2nn4kern3svc25SvcCreateTransferMemory64EPNS_3svc6HandleEmmNS2_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcCreateTransferMemory64EPNS_3svc6HandleEmmNS2_16MemoryPermissionE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv, [.-_ZN2nn4kern3svc7Aarch6424CallCreateTransferMemoryEv]

//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//                                     Register 0  ref  4 pOut
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//     Register 3       8 ns           Register 3       8 ns
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pOut         
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv
    .type    _ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv, %function
    .type    _ZN2nn4kern3svc24SvcWaitSynchronization64EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEil, %function
_ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcWaitSynchronization64EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEil

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv, [.-_ZN2nn4kern3svc7Aarch6423CallWaitSynchronizationEv]

//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, KUserPointer<const char*> name)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1  ref -- name     Register 1  ref -- name
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv
    .type    _ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv, %function
    .type    _ZN2nn4kern3svc23SvcConnectToNamedPort64EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE, %function
_ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcConnectToNamedPort64EPNS_3svc6HandleENS1_12KUserPointerIPKcvEE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv, [.-_ZN2nn4kern3svc7Aarch6422CallConnectToNamedPortEv]

//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//                                     Register 0  ref  4 pEvent
//     Register 1       8 pMessage     Register 1       8 pMessage
//     Register 2       8 bufferSize   Register 2       8 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pEvent       
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv
    .type    _ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc35SvcSendAsyncRequestWithUserBuffer64EPNS_3svc6HandleEmmS3_, %function
_ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pEvent の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pEvent のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc35SvcSendAsyncRequestWithUserBuffer64EPNS_3svc6HandleEmmS3_

    ldr      x1, [sp, #0]              // pEvent の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv, [.-_ZN2nn4kern3svc7Aarch6434CallSendAsyncRequestWithUserBufferEv]

//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     Invariant s=8 r=8 p=8        AArch64 s=8 r=8 p=8
// in  svc                          abi
//                                  Register 0  ref  8 pOut
//     Register 1       4 process   Register 1       4 process
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       8 pOut      
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv
    .type    _ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv, %function
    .type    _ZN2nn4kern3svc17SvcGetProcessId64EPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc17SvcGetProcessId64EPmNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv, [.-_ZN2nn4kern3svc7Aarch6416CallGetProcessIdEv]

//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 thread   Register 1       4 thread
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv
    .type    _ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv, %function
    .type    _ZN2nn4kern3svc16SvcGetThreadId64EPmNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcGetThreadId64EPmNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv, [.-_ZN2nn4kern3svc7Aarch6415CallGetThreadIdEv]

//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6411CallGetInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6411CallGetInfoEv
    .type    _ZN2nn4kern3svc7Aarch6411CallGetInfoEv, %function
    .type    _ZN2nn4kern3svc12SvcGetInfo64EPmNS_3svc8InfoTypeENS3_6HandleEm, %function
_ZN2nn4kern3svc7Aarch6411CallGetInfoEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc12SvcGetInfo64EPmNS_3svc8InfoTypeENS3_6HandleEm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6411CallGetInfoEv, [.-_ZN2nn4kern3svc7Aarch6411CallGetInfoEv]

//-------------------------------------------------
// Result GetDebugFutureThreadInfo(nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
//
//     Invariant s=8 r=8 p=8         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref 32 pContext
//                                   Register 1  ref  8 threadId
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       8 ns         Register 3       8 ns
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      32 pContext   
//     Register 2      32 pContext   
//     Register 3      32 pContext   
//     Register 4      32 pContext   
//     Register 5       8 threadId   
//
// conversion
//   Scatter         pContext
//   Scatter         threadId

    .section .text._ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv
    .type    _ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv, %function
    .type    _ZN2nn4kern3svc29SvcGetDebugFutureThreadInfo64EPNS_3svc4lp6417LastThreadContextEPmNS2_6HandleEl, %function
_ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #48

    str      x1, [sp, #0]              // pContext の第 1 ワードをレジスタからスタックへ
    str      x2, [sp, #8]              // pContext の第 2 ワードをレジスタからスタックへ
    str      x3, [sp, #16]             // pContext の第 3 ワードをレジスタからスタックへ
    str      x4, [sp, #24]             // pContext の第 4 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pContext のアドレスをレジスタへ
    str      x5, [sp, #32]             // threadId の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #32               // threadId のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcGetDebugFutureThreadInfo64EPNS_3svc4lp6417LastThreadContextEPmNS2_6HandleEl

    ldr      x1, [sp, #0]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pContext の第 2 ワードをスタックからレジスタへ
    ldr      x3, [sp, #16]             // pContext の第 3 ワードをスタックからレジスタへ
    ldr      x4, [sp, #24]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      x5, [sp, #32]             // threadId の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #48
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv, [.-_ZN2nn4kern3svc7Aarch6428CallGetDebugFutureThreadInfoEv]

//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     Invariant s=8 r=8 p=8         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref 32 pContext
//                                   Register 1  ref  8 pTlsAddr
//                                   Register 2  ref  4 pFlag
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1      32 pContext   
//     Register 2      32 pContext   
//     Register 3      32 pContext   
//     Register 4      32 pContext   
//     Register 5       8 pTlsAddr   
//     Register 6       4 pFlag      
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv
    .type    _ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv, %function
    .type    _ZN2nn4kern3svc22SvcGetLastThreadInfo64EPNS_3svc4lp6417LastThreadContextEPmPj, %function
_ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #48

    str      x1, [sp, #0]              // pContext の第 1 ワードをレジスタからスタックへ
    str      x2, [sp, #8]              // pContext の第 2 ワードをレジスタからスタックへ
    str      x3, [sp, #16]             // pContext の第 3 ワードをレジスタからスタックへ
    str      x4, [sp, #24]             // pContext の第 4 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pContext のアドレスをレジスタへ
    str      x5, [sp, #32]             // pTlsAddr の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #32               // pTlsAddr のアドレスをレジスタへ
    str      x6, [sp, #40]             // pFlag の第 1 ワードをレジスタからスタックへ
    add      x2, sp, #40               // pFlag のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcGetLastThreadInfo64EPNS_3svc4lp6417LastThreadContextEPmPj

    ldr      x1, [sp, #0]              // pContext の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pContext の第 2 ワードをスタックからレジスタへ
    ldr      x3, [sp, #16]             // pContext の第 3 ワードをスタックからレジスタへ
    ldr      x4, [sp, #24]             // pContext の第 4 ワードをスタックからレジスタへ
    ldr      x5, [sp, #32]             // pTlsAddr の第 1 ワードをスタックからレジスタへ
    ldr      x6, [sp, #40]             // pFlag の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #48
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv, [.-_ZN2nn4kern3svc7Aarch6421CallGetLastThreadInfoEv]

//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=8 r=8 p=8              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv
    .type    _ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv, %function
    .type    _ZN2nn4kern3svc31SvcGetResourceLimitLimitValue64EPlNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc31SvcGetResourceLimitLimitValue64EPlNS_3svc6HandleENS3_17LimitableResourceE

    ldr      x1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv, [.-_ZN2nn4kern3svc7Aarch6430CallGetResourceLimitLimitValueEv]

//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     Invariant s=8 r=8 p=8              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  8 value
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       8 value           
//
// conversion
//   Scatter         value

    .section .text._ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv
    .type    _ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv, %function
    .type    _ZN2nn4kern3svc33SvcGetResourceLimitCurrentValue64EPlNS_3svc6HandleENS3_17LimitableResourceE, %function
_ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // value の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // value のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc33SvcGetResourceLimitCurrentValue64EPlNS_3svc6HandleENS3_17LimitableResourceE

    ldr      x1, [sp, #0]              // value の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv, [.-_ZN2nn4kern3svc7Aarch6432CallGetResourceLimitCurrentValueEv]

//-------------------------------------------------
// Result CreateSession(nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name)
//
//     Invariant s=8 r=8 p=8               AArch64 s=8 r=8 p=8
// in  svc                                 abi
//                                         Register 0  ref  4 pServerSession
//                                         Register 1  ref  4 pClientSession
//     Register 2       1 isLight          Register 2       1 isLight
//     Register 3       8 name             Register 3       8 name
//
// in  svc                                 abi
//     Register 0       4 return           Register 0       4 return
//     Register 1       4 pServerSession   
//     Register 2       4 pClientSession   
//
// conversion
//   Scatter         pServerSession
//   Scatter         pClientSession

    .section .text._ZN2nn4kern3svc7Aarch6417CallCreateSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallCreateSessionEv
    .type    _ZN2nn4kern3svc7Aarch6417CallCreateSessionEv, %function
    .type    _ZN2nn4kern3svc18SvcCreateSession64EPNS_3svc6HandleES4_bm, %function
_ZN2nn4kern3svc7Aarch6417CallCreateSessionEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pServerSession の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pServerSession のアドレスをレジスタへ
    str      x2, [sp, #8]              // pClientSession の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pClientSession のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcCreateSession64EPNS_3svc6HandleES4_bm

    ldr      x1, [sp, #0]              // pServerSession の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pClientSession の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallCreateSessionEv, [.-_ZN2nn4kern3svc7Aarch6417CallCreateSessionEv]

//-------------------------------------------------
// Result AcceptSession(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv
    .type    _ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv, %function
    .type    _ZN2nn4kern3svc18SvcAcceptSession64EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcAcceptSession64EPNS_3svc6HandleES3_

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv, [.-_ZN2nn4kern3svc7Aarch6417CallAcceptSessionEv]

//-------------------------------------------------
// Result ReplyAndReceive(int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pIndex
//     Register 1  ref -- pHandles      Register 1  ref -- pHandles
//     Register 2       4 numHandle     Register 2       4 numHandle
//     Register 3       4 replyTarget   Register 3       4 replyTarget
//     Register 4       8 ns            Register 4       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv
    .type    _ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv, %function
    .type    _ZN2nn4kern3svc20SvcReplyAndReceive64EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l, %function
_ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pIndex の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc20SvcReplyAndReceive64EPiNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l

    ldr      x1, [sp, #0]              // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv, [.-_ZN2nn4kern3svc7Aarch6419CallReplyAndReceiveEv]

//-------------------------------------------------
// Result ReplyAndReceiveWithUserBuffer(int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pIndex
//     Register 1       8 pMessage      Register 1       8 pMessage
//     Register 2       8 bufferSize    Register 2       8 bufferSize
//     Register 3  ref -- pHandles      Register 3  ref -- pHandles
//     Register 4       4 numHandle     Register 4       4 numHandle
//     Register 5       4 replyTarget   Register 5       4 replyTarget
//     Register 6       8 ns            Register 6       8 ns
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pIndex        
//
// conversion
//   Scatter         pIndex

    .section .text._ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv
    .type    _ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv, %function
    .type    _ZN2nn4kern3svc34SvcReplyAndReceiveWithUserBuffer64EPimmNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l, %function
_ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pIndex の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pIndex のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc34SvcReplyAndReceiveWithUserBuffer64EPimmNS1_12KUserPointerIPKNS_3svc6HandleEvEEiS5_l

    ldr      x1, [sp, #0]              // pIndex の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv, [.-_ZN2nn4kern3svc7Aarch6433CallReplyAndReceiveWithUserBufferEv]

//-------------------------------------------------
// Result CreateEvent(nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle)
//
//     Invariant s=8 r=8 p=8             AArch64 s=8 r=8 p=8
// in  svc                               abi
//                                       Register 0  ref  4 pWriteHandle
//                                       Register 1  ref  4 pReadHandle
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pWriteHandle   
//     Register 2       4 pReadHandle    
//
// conversion
//   Scatter         pWriteHandle
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc7Aarch6415CallCreateEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6415CallCreateEventEv
    .type    _ZN2nn4kern3svc7Aarch6415CallCreateEventEv, %function
    .type    _ZN2nn4kern3svc16SvcCreateEvent64EPNS_3svc6HandleES4_, %function
_ZN2nn4kern3svc7Aarch6415CallCreateEventEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pWriteHandle の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pWriteHandle のアドレスをレジスタへ
    str      x2, [sp, #8]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc16SvcCreateEvent64EPNS_3svc6HandleES4_

    ldr      x1, [sp, #0]              // pWriteHandle の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6415CallCreateEventEv, [.-_ZN2nn4kern3svc7Aarch6415CallCreateEventEv]

//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       8 addr     Register 1       8 addr
//     Register 2       8 size     Register 2       8 size
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv, %function
    .type    _ZN2nn4kern3svc21SvcCreateCodeMemory64EPNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc21SvcCreateCodeMemory64EPNS_3svc6HandleEmm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv, [.-_ZN2nn4kern3svc7Aarch6420CallCreateCodeMemoryEv]

//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     Invariant s=8 r=8 p=8        AArch64 s=8 r=8 p=8
// in  svc                          abi
//                                  Register 0  ref  4 pOut
//     Register 1       8 address   Register 1       8 address
//     Register 2       4 mask      Register 2       4 mask
//     Register 3       4 value     Register 3       4 value
//
// in  svc                          abi
//     Register 0       4 return    Register 0       4 return
//     Register 1       4 pOut      
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv
    .type    _ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv, %function
    .type    _ZN2nn4kern3svc22SvcReadWriteRegister64EPjmjj, %function
_ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc22SvcReadWriteRegister64EPjmjj

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv, [.-_ZN2nn4kern3svc7Aarch6421CallReadWriteRegisterEv]

//-------------------------------------------------
// Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
//
//     Invariant s=8 r=8 p=8                AArch64 s=8 r=8 p=8
// in  svc                                  abi
//                                          Register 0  ref  4 pOut
//     Register 1       8 size              Register 1       8 size
//     Register 2       4 myPermission      Register 2       4 myPermission
//     Register 3       4 otherPermission   Register 3       4 otherPermission
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       4 pOut              
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv, %function
    .type    _ZN2nn4kern3svc23SvcCreateSharedMemory64EPNS_3svc6HandleEmNS2_16MemoryPermissionES5_, %function
_ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcCreateSharedMemory64EPNS_3svc6HandleEmNS2_16MemoryPermissionES5_

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv, [.-_ZN2nn4kern3svc7Aarch6422CallCreateSharedMemoryEv]

//-------------------------------------------------
// Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pReadHandle
//     Register 1       4 name          Register 1       4 name
//     Register 2       4 type          Register 2       4 type
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pReadHandle   
//
// conversion
//   Scatter         pReadHandle

    .section .text._ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv
    .type    _ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv, %function
    .type    _ZN2nn4kern3svc25SvcCreateInterruptEvent64EPNS_3svc6HandleEiNS2_13InterruptTypeE, %function
_ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pReadHandle の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pReadHandle のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcCreateInterruptEvent64EPNS_3svc6HandleEiNS2_13InterruptTypeE

    ldr      x1, [sp, #0]              // pReadHandle の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv, [.-_ZN2nn4kern3svc7Aarch6424CallCreateInterruptEventEv]

//-------------------------------------------------
// Result QueryPhysicalAddress(nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//                                     Register 0  ref 24 pBlockInfo
//     Register 1       8 addr         Register 1       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1      24 pBlockInfo   
//     Register 2      24 pBlockInfo   
//     Register 3      24 pBlockInfo   
//
// conversion
//   Scatter         pBlockInfo

    .section .text._ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv
    .type    _ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv, %function
    .type    _ZN2nn4kern3svc25SvcQueryPhysicalAddress64EPNS_3svc4lp6418PhysicalMemoryInfoEm, %function
_ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #32

    str      x1, [sp, #0]              // pBlockInfo の第 1 ワードをレジスタからスタックへ
    str      x2, [sp, #8]              // pBlockInfo の第 2 ワードをレジスタからスタックへ
    str      x3, [sp, #16]             // pBlockInfo の第 3 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pBlockInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc25SvcQueryPhysicalAddress64EPNS_3svc4lp6418PhysicalMemoryInfoEm

    ldr      x1, [sp, #0]              // pBlockInfo の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pBlockInfo の第 2 ワードをスタックからレジスタへ
    ldr      x3, [sp, #16]             // pBlockInfo の第 3 ワードをスタックからレジスタへ

    add      sp, sp, #32
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv, [.-_ZN2nn4kern3svc7Aarch6424CallQueryPhysicalAddressEv]

//-------------------------------------------------
// Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
//
//     Invariant s=8 r=8 p=8                AArch64 s=8 r=8 p=8
// in  svc                                  abi
//                                          Register 0  ref  8 pOut
//     Register 1       8 physicalAddress   Register 1       8 physicalAddress
//     Register 2       8 size              Register 2       8 size
//
// in  svc                                  abi
//     Register 0       4 return            Register 0       4 return
//     Register 1       8 pOut              
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv
    .type    _ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv, %function
    .type    _ZN2nn4kern3svc19SvcQueryIoMapping64EPmmm, %function
_ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcQueryIoMapping64EPmmm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv, [.-_ZN2nn4kern3svc7Aarch6418CallQueryIoMappingEv]

//-------------------------------------------------
// Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
//
//     Invariant s=8 r=8 p=8             AArch64 s=8 r=8 p=8
// in  svc                               abi
//                                       Register 0  ref  4 pOut
//     Register 1       8 spaceAddress   Register 1       8 spaceAddress
//     Register 2       8 spaceSize      Register 2       8 spaceSize
//
// in  svc                               abi
//     Register 0       4 return         Register 0       4 return
//     Register 1       4 pOut           
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc29SvcCreateDeviceAddressSpace64EPNS_3svc6HandleEmm, %function
_ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc29SvcCreateDeviceAddressSpace64EPNS_3svc6HandleEmm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc7Aarch6428CallCreateDeviceAddressSpaceEv]

//-------------------------------------------------
// Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     Invariant s=8 r=8 p=8                 AArch64 s=8 r=8 p=8
// in  svc                                   abi
//                                           Register 0  ref  8 pMappedSize
//     Register 1       4 addressSpace       Register 1       4 addressSpace
//     Register 2       4 process            Register 2       4 process
//     Register 3       8 processAddress     Register 3       8 processAddress
//     Register 4       8 size               Register 4       8 size
//     Register 5       8 deviceAddress      Register 5       8 deviceAddress
//     Register 6       4 devicePermission   Register 6       4 devicePermission
//
// in  svc                                   abi
//     Register 0       4 return             Register 0       4 return
//     Register 1       8 pMappedSize        
//
// conversion
//   Scatter         pMappedSize

    .section .text._ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv
    .type    _ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv, %function
    .type    _ZN2nn4kern3svc26SvcMapDeviceAddressSpace64EPmNS_3svc6HandleES4_mmmNS3_16MemoryPermissionE, %function
_ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pMappedSize の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pMappedSize のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc26SvcMapDeviceAddressSpace64EPmNS_3svc6HandleES4_mmmNS3_16MemoryPermissionE

    ldr      x1, [sp, #0]              // pMappedSize の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv, [.-_ZN2nn4kern3svc7Aarch6425CallMapDeviceAddressSpaceEv]

//-------------------------------------------------
// Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
//
//     Invariant s=8 r=8 p=8          AArch64 s=8 r=8 p=8
// in  svc                            abi
//                                    Register 0  ref  4 pOut
//     Register 1       8 processId   Register 1       8 processId
//
// in  svc                            abi
//     Register 0       4 return      Register 0       4 return
//     Register 1       4 pOut        
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv
    .type    _ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv, %function
    .type    _ZN2nn4kern3svc23SvcDebugActiveProcess64EPNS_3svc6HandleEm, %function
_ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcDebugActiveProcess64EPNS_3svc6HandleEm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv, [.-_ZN2nn4kern3svc7Aarch6422CallDebugActiveProcessEv]

//-------------------------------------------------
// Result GetProcessList(int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize)
//
//     Invariant s=8 r=8 p=8              AArch64 s=8 r=8 p=8
// in  svc                                abi
//                                        Register 0  ref  4 pNumProcesses
//     Register 1  ref -- pProcessIds     Register 1  ref -- pProcessIds
//     Register 2       4 arraySize       Register 2       4 arraySize
//
// in  svc                                abi
//     Register 0       4 return          Register 0       4 return
//     Register 1       4 pNumProcesses   
//
// conversion
//   Scatter         pNumProcesses

    .section .text._ZN2nn4kern3svc7Aarch6418CallGetProcessListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6418CallGetProcessListEv
    .type    _ZN2nn4kern3svc7Aarch6418CallGetProcessListEv, %function
    .type    _ZN2nn4kern3svc19SvcGetProcessList64EPiNS1_12KUserPointerIPmvEEi, %function
_ZN2nn4kern3svc7Aarch6418CallGetProcessListEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pNumProcesses の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pNumProcesses のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcGetProcessList64EPiNS1_12KUserPointerIPmvEEi

    ldr      x1, [sp, #0]              // pNumProcesses の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6418CallGetProcessListEv, [.-_ZN2nn4kern3svc7Aarch6418CallGetProcessListEv]

//-------------------------------------------------
// Result GetThreadList(int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pNumThreads
//     Register 1  ref -- pThreadIds    Register 1  ref -- pThreadIds
//     Register 2       4 arraySize     Register 2       4 arraySize
//     Register 3       4 domain        Register 3       4 domain
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pNumThreads   
//
// conversion
//   Scatter         pNumThreads

    .section .text._ZN2nn4kern3svc7Aarch6417CallGetThreadListEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallGetThreadListEv
    .type    _ZN2nn4kern3svc7Aarch6417CallGetThreadListEv, %function
    .type    _ZN2nn4kern3svc18SvcGetThreadList64EPiNS1_12KUserPointerIPmvEEiNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6417CallGetThreadListEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pNumThreads の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pNumThreads のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcGetThreadList64EPiNS1_12KUserPointerIPmvEEiNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pNumThreads の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallGetThreadListEv, [.-_ZN2nn4kern3svc7Aarch6417CallGetThreadListEv]

//-------------------------------------------------
// Result QueryDebugProcessMemory(KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         Register 3       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc28SvcQueryDebugProcessMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm, %function
_ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc28SvcQueryDebugProcessMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm

    ldr      x1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch6427CallQueryDebugProcessMemoryEv]

//-------------------------------------------------
// Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
//
//     Invariant s=8 r=8 p=8         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref  8 pOut1
//                                   Register 1  ref  4 pOut2
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       8 threadId   Register 3       8 threadId
//     Register 4       4 select     Register 4       4 select
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       8 pOut1      
//     Register 2       4 pOut2      
//
// conversion
//   Scatter         pOut1
//   Scatter         pOut2

    .section .text._ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv
    .type    _ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv, %function
    .type    _ZN2nn4kern3svc24SvcGetDebugThreadParam64EPmPjNS_3svc6HandleEmNS4_16DebugThreadParamE, %function
_ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut1 の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut1 のアドレスをレジスタへ
    str      x2, [sp, #8]              // pOut2 の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pOut2 のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcGetDebugThreadParam64EPmPjNS_3svc6HandleEmNS4_16DebugThreadParamE

    ldr      x1, [sp, #0]              // pOut1 の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pOut2 の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv, [.-_ZN2nn4kern3svc7Aarch6423CallGetDebugThreadParamEv]

//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv
    .type    _ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv, %function
    .type    _ZN2nn4kern3svc18SvcGetSystemInfo64EPmNS_3svc14SystemInfoTypeENS3_6HandleEm, %function
_ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcGetSystemInfo64EPmNS_3svc14SystemInfoTypeENS3_6HandleEm

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv, [.-_ZN2nn4kern3svc7Aarch6417CallGetSystemInfoEv]

//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pOutServer
//                                      Register 1  ref  4 pOutClient
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//     Register 4       8 name          Register 4       8 name
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//     Register 2       4 pOutClient    
//
// conversion
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn4kern3svc7Aarch6414CallCreatePortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6414CallCreatePortEv
    .type    _ZN2nn4kern3svc7Aarch6414CallCreatePortEv, %function
    .type    _ZN2nn4kern3svc15SvcCreatePort64EPNS_3svc6HandleES4_ibm, %function
_ZN2nn4kern3svc7Aarch6414CallCreatePortEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOutServer のアドレスをレジスタへ
    str      x2, [sp, #8]              // pOutClient の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #8                // pOutClient のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc15SvcCreatePort64EPNS_3svc6HandleES4_ibm

    ldr      x1, [sp, #0]              // pOutServer の第 1 ワードをスタックからレジスタへ
    ldr      x2, [sp, #8]              // pOutClient の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6414CallCreatePortEv, [.-_ZN2nn4kern3svc7Aarch6414CallCreatePortEv]

//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions)
//
//     Invariant s=8 r=8 p=8            AArch64 s=8 r=8 p=8
// in  svc                              abi
//                                      Register 0  ref  4 pOutServer
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// in  svc                              abi
//     Register 0       4 return        Register 0       4 return
//     Register 1       4 pOutServer    
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv
    .type    _ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv, %function
    .type    _ZN2nn4kern3svc20SvcManageNamedPort64EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi, %function
_ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOutServer の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOutServer のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc20SvcManageNamedPort64EPNS_3svc6HandleENS1_12KUserPointerIPKcvEEi

    ldr      x1, [sp, #0]              // pOutServer の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv, [.-_ZN2nn4kern3svc7Aarch6419CallManageNamedPortEv]

//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//     Register 1       4 port     Register 1       4 port
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6417CallConnectToPortEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallConnectToPortEv
    .type    _ZN2nn4kern3svc7Aarch6417CallConnectToPortEv, %function
    .type    _ZN2nn4kern3svc18SvcConnectToPort64EPNS_3svc6HandleES3_, %function
_ZN2nn4kern3svc7Aarch6417CallConnectToPortEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcConnectToPort64EPNS_3svc6HandleES3_

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallConnectToPortEv, [.-_ZN2nn4kern3svc7Aarch6417CallConnectToPortEv]

//-------------------------------------------------
// Result QueryProcessMemory(KUserPointer<nn::svc::lp64::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     Invariant s=8 r=8 p=8           AArch64 s=8 r=8 p=8
// in  svc                             abi
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//                                     Register 1  ref  4 pPageInfo
//     Register 2       4 process      Register 2       4 process
//     Register 3       8 addr         Register 3       8 addr
//
// in  svc                             abi
//     Register 0       4 return       Register 0       4 return
//     Register 1       4 pPageInfo    
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv
    .type    _ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv, %function
    .type    _ZN2nn4kern3svc23SvcQueryProcessMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm, %function
_ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pPageInfo の第 1 ワードをレジスタからスタックへ
    add      x1, sp, #0                // pPageInfo のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc23SvcQueryProcessMemory64ENS1_12KUserPointerIPNS_3svc4lp6410MemoryInfoEvEEPNS3_8PageInfoENS3_6HandleEm

    ldr      x1, [sp, #0]              // pPageInfo の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv, [.-_ZN2nn4kern3svc7Aarch6422CallQueryProcessMemoryEv]

//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, KUserPointer<const nn::svc::lp64::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum)
//
//     Invariant s=8 r=8 p=8         AArch64 s=8 r=8 p=8
// in  svc                           abi
//                                   Register 0  ref  4 pOut
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// in  svc                           abi
//     Register 0       4 return     Register 0       4 return
//     Register 1       4 pOut       
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6417CallCreateProcessEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6417CallCreateProcessEv
    .type    _ZN2nn4kern3svc7Aarch6417CallCreateProcessEv, %function
    .type    _ZN2nn4kern3svc18SvcCreateProcess64EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_4lp6422CreateProcessParameterEvEENS5_IPKjvEEi, %function
_ZN2nn4kern3svc7Aarch6417CallCreateProcessEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc18SvcCreateProcess64EPNS_3svc6HandleENS1_12KUserPointerIPKNS2_4lp6422CreateProcessParameterEvEENS5_IPKjvEEi

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6417CallCreateProcessEv, [.-_ZN2nn4kern3svc7Aarch6417CallCreateProcessEv]

//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  8 pOut
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       8 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv
    .type    _ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv, %function
    .type    _ZN2nn4kern3svc19SvcGetProcessInfo64EPlNS_3svc6HandleENS3_15ProcessInfoTypeE, %function
_ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc19SvcGetProcessInfo64EPlNS_3svc6HandleENS3_15ProcessInfoTypeE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv, [.-_ZN2nn4kern3svc7Aarch6418CallGetProcessInfoEv]

//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     Invariant s=8 r=8 p=8       AArch64 s=8 r=8 p=8
// in  svc                         abi
//                                 Register 0  ref  4 pOut
//
// in  svc                         abi
//     Register 0       4 return   Register 0       4 return
//     Register 1       4 pOut     
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv, "ax"
    .align   2
    .global  _ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv
    .type    _ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv, %function
    .type    _ZN2nn4kern3svc24SvcCreateResourceLimit64EPNS_3svc6HandleE, %function
_ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv:

    stp      x29, x30, [sp, #-16]!
    sub      sp, sp, #16

    str      x1, [sp, #0]              // pOut の第 1 ワードをレジスタからスタックへ
    add      x0, sp, #0                // pOut のアドレスをレジスタへ

    bl       _ZN2nn4kern3svc24SvcCreateResourceLimit64EPNS_3svc6HandleE

    ldr      x1, [sp, #0]              // pOut の第 1 ワードをスタックからレジスタへ

    add      sp, sp, #16
    ldp      x29, x30, [sp], #16
    ret

    .size _ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv, [.-_ZN2nn4kern3svc7Aarch6423CallCreateResourceLimitEv]

    .end

