﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include "kern_RegisterDefinition.h"

// MRS/MSR
#define HW_INST_MRS(a,v)            __asm volatile("mrs %0," #a "": "=&r"(v)::"memory")
#define HW_INST_MSR(a,v)            __asm volatile("msr " #a ", %0"::"r"(v):"memory","cc")
// MRC/MCR
// a: CP, b: Op1, c: CRn, d: CRm, e: Op2
#define HW_INST_MRC(a,b,c,d,e,v)    __asm volatile("mrc  "#a", %1, %0,"#c","#d", %2": "=&r"(v):"i"(b),"i"(e):"memory")
#define HW_INST_MCR(a,b,c,d,e,v)    __asm volatile("mcr  "#a", %1, %0,"#c","#d", %2": :"r"(v),"i"(b),"i"(e):"memory")

#define HW_GET_MPIDR_EL1(v)                 HW_INST_MRS(mpidr_el1, v)

#define HW_SET_THREAD_ID_USER_READ_ONLY(v)  HW_INST_MSR(tpidrro_el0, v)
#define HW_GET_THREAD_ID_USER_READ_ONLY(v)  HW_INST_MRS(tpidrro_el0, v)

#define HW_SET_VBAR_EL1(v)                  HW_INST_MSR(vbar_el1, v)
#define HW_GET_VBAR_EL1(v)                  HW_INST_MRS(vbar_el1, v)

#define HW_SET_MAIR_EL1(v)                  HW_INST_MSR(mair_el1, v)
#define HW_GET_MAIR_EL1(v)                  HW_INST_MRS(mair_el1, v)

#define HW_SET_TTBR0_EL1(v)                 HW_INST_MSR(ttbr0_el1, v)
#define HW_GET_TTBR0_EL1(v)                 HW_INST_MRS(ttbr0_el1, v)

#define HW_SET_TTBR1_EL1(v)                 HW_INST_MSR(ttbr1_el1, v)
#define HW_GET_TTBR1_EL1(v)                 HW_INST_MRS(ttbr1_el1, v)

#define HW_SET_TCR_EL1(v)                   HW_INST_MSR(tcr_el1, v)
#define HW_GET_TCR_EL1(v)                   HW_INST_MRS(tcr_el1, v)

#define HW_SET_FAR_EL1(v)                   HW_INST_MSR(far_el1, v)
#define HW_GET_FAR_EL1(v)                   HW_INST_MRS(far_el1, v)

#define HW_GET_AFSR0_EL1(v)                 HW_INST_MRS(afsr0_el1, v)
#define HW_GET_AFSR1_EL1(v)                 HW_INST_MRS(afsr1_el1, v)

#define HW_SET_ESR_EL1(v)                   HW_INST_MSR(esr_el1, v)
#define HW_GET_ESR_EL1(v)                   HW_INST_MRS(esr_el1, v)

#define HW_SET_PAR_EL1(v)                   HW_INST_MSR(par_el1, v)
#define HW_GET_PAR_EL1(v)                   HW_INST_MRS(par_el1, v)

#define HW_SET_CNTFRQ_EL0(v)                HW_INST_MSR(cntfrq_el0, v)
#define HW_GET_CNTFRQ_EL0(v)                HW_INST_MRS(cntfrq_el0, v)

#define HW_SET_CNTKCTL_EL1(v)               HW_INST_MSR(cntkctl_el1, v)
#define HW_GET_CNTKCTL_EL1(v)               HW_INST_MRS(cntkctl_el1, v)

#define HW_SET_CNTP_CTL_EL0(v)              HW_INST_MSR(cntp_ctl_el0, v)
#define HW_GET_CNTP_CTL_EL0(v)              HW_INST_MRS(cntp_ctl_el0, v)

#define HW_SET_CNTP_CVAL_EL0(v)             HW_INST_MSR(cntp_cval_el0, v)
#define HW_GET_CNTP_CVAL_EL0(v)             HW_INST_MRS(cntp_cval_el0, v)

#define HW_SET_CNTP_TVAL_EL0(v)             HW_INST_MSR(cntp_tval_el0, v)
#define HW_GET_CNTP_TVAL_EL0(v)             HW_INST_MRS(cntp_tval_el0, v)

#define HW_SET_CNTPCT_EL0(v)                HW_INST_MSR(cntpct_el0, v)
#define HW_GET_CNTPCT_EL0(v)                HW_INST_MRS(cntpct_el0, v)

#define HW_SET_CPACR_EL1(v)                 HW_INST_MSR(cpacr_el1, v)
#define HW_GET_CPACR_EL1(v)                 HW_INST_MRS(cpacr_el1, v)

#define HW_GET_CCSIDR_EL1(v)                HW_INST_MRS(ccsidr_el1, v)
#define HW_GET_CLIDR_EL1(v)                 HW_INST_MRS(clidr_el1, v)
#define HW_GET_CTR_EL0(v)                   HW_INST_MRS(ctr_el0, v)

#define HW_SET_CSSELR_EL1(v)                HW_INST_MSR(csselr_el1, v)
#define HW_GET_CSSELR_EL1(v)                HW_INST_MRS(csselr_el1, v)

#define HW_SET_SCTLR_EL1(v)                 HW_INST_MSR(sctlr_el1, v)
#define HW_GET_SCTLR_EL1(v)                 HW_INST_MRS(sctlr_el1, v)

#define HW_SET_CPUECTLR_EL1(v)              HW_INST_MSR(s3_1_c15_c2_1, v)
#define HW_GET_CPUECTLR_EL1(v)              HW_INST_MRS(s3_1_c15_c2_1, v)

#define HW_SET_CPUACTLR_EL1(v)              HW_INST_MSR(s3_1_c15_c2_0, v)
#define HW_GET_CPUACTLR_EL1(v)              HW_INST_MRS(s3_1_c15_c2_0, v)

#define HW_SET_OSLAR_EL1(v)                 HW_INST_MSR(oslar_el1, v)

#define HW_SET_DBGBCR_EL1(i, v)             __asm volatile("msr DBGBCR" #i "_el1, %0":: "r"(v):"memory")
#define HW_GET_DBGBCR_EL1(i, v)             __asm volatile("mrs %0, DBGBCR" #i "_el1": "=&r"(v)::"memory")

#define HW_SET_DBGBVR_EL1(i, v)             __asm volatile("msr DBGBVR" #i "_el1, %0":: "r"(v):"memory")
#define HW_GET_DBGBVR_EL1(i, v)             __asm volatile("mrs %0, DBGBVR" #i "_el1": "=&r"(v)::"memory")

#define HW_SET_DBGWCR_EL1(i, v)             __asm volatile("msr DBGWCR" #i "_el1, %0":: "r"(v):"memory")
#define HW_GET_DBGWCR_EL1(i, v)             __asm volatile("mrs %0, DBGWCR" #i "_el1": "=&r"(v)::"memory")

#define HW_SET_DBGWVR_EL1(i, v)             __asm volatile("msr DBGWVR" #i "_el1, %0":: "r"(v):"memory")
#define HW_GET_DBGWVR_EL1(i, v)             __asm volatile("mrs %0, DBGWVR" #i "_el1": "=&r"(v)::"memory")

#define HW_SET_MDSCR_EL1(v)                 HW_INST_MSR(mdscr_el1, v)
#define HW_GET_MDSCR_EL1(v)                 HW_INST_MRS(mdscr_el1, v)

#define HW_SET_CONTEXTIDR_EL1(v)            HW_INST_MSR(contextidr_el1, v)
#define HW_GET_CONTEXTIDR_EL1(v)            HW_INST_MRS(contextidr_el1, v)

#define HW_GET_ID_AA64DFR0_EL1(v)           HW_INST_MRS(id_aa64dfr0_el1, v)

#if defined NN_BUILD_CONFIG_HARDWARE_SMMA53
#define HW_GET_CBAR_EL1(v)                  do { (v) = 0x2C000000; } while (NN_STATIC_CONDITION(0))
#else
#define HW_GET_CBAR_EL1(v)                  HW_INST_MRS(s3_1_c15_c3_0, v)
#endif


#define HW_GET_ID_AA64DFR0_EL1(v)           HW_INST_MRS(id_aa64dfr0_el1, v)

#define HW_SET_PMUSERENR_EL0(v)             HW_INST_MSR(pmuserenr_el0, v)
#define HW_GET_PMUSERENR_EL0(v)             HW_INST_MRS(pmuserenr_el0, v)

#define HW_SET_PMCR_EL0(v)                  HW_INST_MSR(pmcr_el0, v)
#define HW_GET_PMCR_EL0(v)                  HW_INST_MRS(pmcr_el0, v)

#define HW_SET_PMOVSCLR_EL0(v)              HW_INST_MSR(pmovsclr_el0, v)
#define HW_GET_PMOVSCLR_EL0(v)              HW_INST_MRS(pmovsclr_el0, v)

#define HW_SET_PMCNTENSET_EL0(v)            HW_INST_MSR(pmcntenset_el0, v)
#define HW_GET_PMCNTENSET_EL0(v)            HW_INST_MRS(pmcntenset_el0, v)

#define HW_SET_PMINTENSET_EL1(v)            HW_INST_MSR(pmintenset_el1, v)
#define HW_GET_PMINTENSET_EL1(v)            HW_INST_MRS(pmintenset_el1, v)

#define HW_SET_PMINTENCLR_EL1(v)            HW_INST_MSR(pmintenclr_el1, v)
#define HW_GET_PMINTENCLR_EL1(v)            HW_INST_MRS(pmintenclr_el1, v)

#define HW_SET_PMCNTENCLR_EL0(v)            HW_INST_MSR(pmcntenclr_el0, v)
#define HW_GET_PMCNTENCLR_EL0(v)            HW_INST_MRS(pmcntenclr_el0, v)

#define HW_SET_PMCCFILTR_EL0(v)             HW_INST_MSR(pmccfiltr_el0, v)
#define HW_GET_PMCCFILTR_EL0(v)             HW_INST_MRS(pmccfiltr_el0, v)

#define HW_SET_PMEVTYPER_EL0(i, v)          __asm volatile("msr PMEVTYPER" #i "_el0, %0":: "r"(v):"memory")
#define HW_GET_PMEVTYPER_EL0(i, v)          __asm volatile("mrs %0, PMEVTYPER" #i "_el0": "=&r"(v)::"memory")

#define HW_SET_PMCCNTR_EL0(v)               HW_INST_MSR(pmccntr_el0, v)
#define HW_GET_PMCCNTR_EL0(v)               HW_INST_MRS(pmccntr_el0, v)

#define HW_SET_PMOVSSET_EL0(v)              HW_INST_MSR(pmovsset_el0, v)
#define HW_GET_PMOVSSET_EL0(v)              HW_INST_MRS(pmovsset_el0, v)

#define HW_SET_PMSELR_EL0(v)                HW_INST_MSR(pmselr_el0, v)
#define HW_GET_PMSELR_EL0(v)                HW_INST_MRS(pmselr_el0, v)

#define HW_SET_PMEVCNTR_EL0(i, v)           __asm volatile("msr PMEVCNTR" #i "_el0, %0":: "r"(v):"memory")
#define HW_GET_PMEVCNTR_EL0(i, v)           __asm volatile("mrs %0, PMEVCNTR" #i "_el0": "=&r"(v)::"memory")

#define HW_SET_TPIDR_EL0(v)                 HW_INST_MSR(tpidr_el0, v)
#define HW_GET_TPIDR_EL0(v)                 HW_INST_MRS(tpidr_el0, v)

#define HW_SET_TPIDR_EL1(v)                 HW_INST_MSR(tpidr_el1, v)
#define HW_GET_TPIDR_EL1(v)                 HW_INST_MRS(tpidr_el1, v)

#define HW_SET_ELR_EL1(v)                   HW_INST_MSR(elr_el1, v)
#define HW_GET_ELR_EL1(v)                   HW_INST_MRS(elr_el1, v)

#define HW_SET_SP_EL0(v)                    HW_INST_MSR(sp_el0, v)
#define HW_GET_SP_EL0(v)                    HW_INST_MRS(sp_el0, v)

#define HW_SET_SPSR_EL1(v)                  HW_INST_MSR(spsr_el1, v)
#define HW_GET_SPSR_EL1(v)                  HW_INST_MRS(spsr_el1, v)

#define HW_SET_DAIF(v)                      HW_INST_MSR(daif, v)
#define HW_GET_DAIF(v)                      HW_INST_MRS(daif, v)

#define HW_GET_MIDR_EL1(v)                  HW_INST_MRS(midr_el1, v)

