﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM64/kern_Assembly.h"

    .section ".exp_vector","xa"


ENTRY(_ZN2nn4kern5ARM6421UserModeThreadStarterEv)
    str wzr, [sp, #(STACK_OFFSET + PARAMS_ON_STACK_DISCOUNT)]

    bl _ZN2nn4kern5ARM6413onThreadStartEv

    ldp x30, x19, [sp, #(EXCEPTION_CONTEXT_X30)]
    ldp x20, x21, [sp, #(EXCEPTION_CONTEXT_PC)]
    ldr x22,      [sp, #(EXCEPTION_CONTEXT_TPIDR)]

    msr sp_el0, x19
    msr elr_el1, x20
    msr spsr_el1, x21
    msr tpidr_el0, x22

    ldp x0, x1,   [sp, #(EXCEPTION_CONTEXT_X0)]
    ldp x2, x3,   [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 2)]
    ldp x4, x5,   [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 4)]
    ldp x6, x7,   [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 6)]
    ldp x8, x9,   [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 8)]
    ldp x10, x11, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 10)]
    ldp x12, x13, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 12)]
    ldp x14, x15, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 14)]
    ldp x16, x17, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 16)]
    ldp x18, x19, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 18)]
    ldp x20, x21, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 20)]
    ldp x22, x23, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 22)]
    ldp x24, x25, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 24)]
    ldp x26, x27, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 26)]
    ldp x28, x29, [sp, #(EXCEPTION_CONTEXT_X0 + 8 * 28)]

    add sp, sp, #STACK_OFFSET
    eret
SET_SIZE(_ZN2nn4kern5ARM6421UserModeThreadStarterEv)

ENTRY(_ZN2nn4kern5ARM6427SupervisorModeThreadStarterEv)
    ldp x0, x1, [sp], #(8 * 2)

    str wzr, [sp, #PARAMS_ON_STACK_DISCOUNT]

    msr daifclr, #2
    br  x1
    eret
SET_SIZE(_ZN2nn4kern5ARM6427SupervisorModeThreadStarterEv)

ENTRY(_ZN2nn4kern5ARM648KContext12RestoreFpu64ERKS2_)
    //---- FPCR, FPSR 保存
    ldr     x1, [x0, #KCONTEXT_FPCR]
    msr     fpcr, x1
    ldr     x1, [x0, #KCONTEXT_FPSR]
    msr     fpsr, x1

    //---- FPU 数値レジスタ保存
    ldp     q0, q1, [x0, #KCONTEXT_FPUREGISTERS + 0 * 16 * 2]
    ldp     q2, q3, [x0, #KCONTEXT_FPUREGISTERS + 1 * 16 * 2]
    ldp     q4, q5, [x0, #KCONTEXT_FPUREGISTERS + 2 * 16 * 2]
    ldp     q6, q7, [x0, #KCONTEXT_FPUREGISTERS + 3 * 16 * 2]
    ldp     q8, q9, [x0, #KCONTEXT_FPUREGISTERS + 4 * 16 * 2]
    ldp     q10, q11, [x0, #KCONTEXT_FPUREGISTERS + 5 * 16 * 2]
    ldp     q12, q13, [x0, #KCONTEXT_FPUREGISTERS + 6 * 16 * 2]
    ldp     q14, q15, [x0, #KCONTEXT_FPUREGISTERS + 7 * 16 * 2]
    ldp     q16, q17, [x0, #KCONTEXT_FPUREGISTERS + 8 * 16 * 2]
    ldp     q18, q19, [x0, #KCONTEXT_FPUREGISTERS + 9 * 16 * 2]
    ldp     q20, q21, [x0, #KCONTEXT_FPUREGISTERS + 10 * 16 * 2]
    ldp     q22, q23, [x0, #KCONTEXT_FPUREGISTERS + 11 * 16 * 2]
    ldp     q24, q25, [x0, #KCONTEXT_FPUREGISTERS + 12 * 16 * 2]
    ldp     q26, q27, [x0, #KCONTEXT_FPUREGISTERS + 13 * 16 * 2]
    ldp     q28, q29, [x0, #KCONTEXT_FPUREGISTERS + 14 * 16 * 2]
    ldp     q30, q31, [x0, #KCONTEXT_FPUREGISTERS + 15 * 16 * 2]

    ret
SET_SIZE(_ZN2nn4kern5ARM648KContext12RestoreFpu64ERKS2_)

ENTRY(_ZN2nn4kern5ARM648KContext12RestoreFpu32ERKS2_)
    //---- FPCR, FPSR 保存
    ldr     x1, [x0, #KCONTEXT_FPCR]
    msr     fpcr, x1
    ldr     x1, [x0, #KCONTEXT_FPSR]
    msr     fpsr, x1

    //---- FPU 数値レジスタ保存
    ldp     q0, q1, [x0, #KCONTEXT_FPUREGISTERS + 0 * 16 * 2]
    ldp     q2, q3, [x0, #KCONTEXT_FPUREGISTERS + 1 * 16 * 2]
    ldp     q4, q5, [x0, #KCONTEXT_FPUREGISTERS + 2 * 16 * 2]
    ldp     q6, q7, [x0, #KCONTEXT_FPUREGISTERS + 3 * 16 * 2]
    ldp     q8, q9, [x0, #KCONTEXT_FPUREGISTERS + 4 * 16 * 2]
    ldp     q10, q11, [x0, #KCONTEXT_FPUREGISTERS + 5 * 16 * 2]
    ldp     q12, q13, [x0, #KCONTEXT_FPUREGISTERS + 6 * 16 * 2]
    ldp     q14, q15, [x0, #KCONTEXT_FPUREGISTERS + 7 * 16 * 2]

    ret
SET_SIZE(_ZN2nn4kern5ARM648KContext12RestoreFpu32ERKS2_)

