﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#pragma once

#include "../../../svc/kern_KUserPointer.h"
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_BaseType.h>
#include <nn/svc/svc_DdType.h>
#include <nn/svc/svc_DmntType.h>
#include <nn/svc/svc_Handle.h>
#include <nn/svc/svc_ServerType.h>
#include <nn/svc/svc_TcbType.h>

#include <nn/svc/svc_BaseType.ilp32.autogen.h>
#include <nn/svc/svc_DdType.ilp32.autogen.h>
#include <nn/svc/svc_DmntType.ilp32.autogen.h>
#include <nn/svc/svc_TcbType.ilp32.autogen.h>

#ifdef __cplusplus

namespace nn {
namespace kern {
namespace svc {

    Result  SvcSetHeapSize32                    (uintptr_t* pOut, size_t size);
    Result  SvcSetMemoryPermission32            (uintptr_t addr, size_t size, nn::svc::MemoryPermission permission);
    Result  SvcSetMemoryAttribute32             (uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute);
    Result  SvcMapMemory32                      (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcUnmapMemory32                    (uintptr_t toAddr, uintptr_t fromAddr, size_t size);
    Result  SvcQueryMemory32                    (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr);
    void    SvcExitProcess32                    ();
    Result  SvcCreateThread32                   (nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore);
    Result  SvcStartThread32                    (nn::svc::Handle thread);
    void    SvcExitThread32                     ();
    void    SvcSleepThread32                    (int64_t ns);
    Result  SvcGetThreadPriority32              (int32_t* pOut, nn::svc::Handle thread);
    Result  SvcSetThreadPriority32              (nn::svc::Handle thread, int32_t priority);
    Result  SvcGetThreadCoreMask32              (int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread);
    Result  SvcSetThreadCoreMask32              (nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask);
    int32_t SvcGetCurrentProcessorNumber32      ();
    Result  SvcSignalEvent32                    (nn::svc::Handle event);
    Result  SvcClearEvent32                     (nn::svc::Handle event);
    Result  SvcMapSharedMemory32                (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcUnmapSharedMemory32              (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateTransferMemory32           (nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission);
    Result  SvcCloseHandle32                    (nn::svc::Handle handle);
    Result  SvcResetSignal32                    (nn::svc::Handle handle);
    Result  SvcWaitSynchronization32            (int32_t* pOut, KUserPointer<const nn::svc::Handle*> handles, int32_t numHandles, int64_t ns);
    Result  SvcCancelSynchronization32          (nn::svc::Handle handle);
    Result  SvcArbitrateLock32                  (nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue);
    Result  SvcArbitrateUnlock32                (uintptr_t addr);
    Result  SvcWaitProcessWideKeyAtomic32       (uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns);
    void    SvcSignalProcessWideKey32           (uintptr_t cvKey, int32_t num);
    int64_t SvcGetSystemTick32                  ();
    Result  SvcConnectToNamedPort32             (nn::svc::Handle* pOut, KUserPointer<const char*> name);
    Result  SvcSendSyncRequestLight32           (nn::svc::Handle session);
    Result  SvcSendSyncRequest32                (nn::svc::Handle session);
    Result  SvcSendSyncRequestWithUserBuffer32  (uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcSendAsyncRequestWithUserBuffer32 (nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session);
    Result  SvcGetProcessId32                   (nn::Bit64* pOut, nn::svc::Handle process);
    Result  SvcGetThreadId32                    (nn::Bit64* pOut, nn::svc::Handle thread);
    void    SvcBreak32                          (nn::svc::BreakReason reason, uintptr_t data, size_t length);
    Result  SvcOutputDebugString32              (KUserPointer<const char*> text, size_t length);
    void    SvcReturnFromException32            (nn::Result result);
    Result  SvcGetInfo32                        (nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param);
    void    SvcFlushEntireDataCache32           ();
    Result  SvcFlushDataCache32                 (uintptr_t addr, size_t size);
    Result  SvcMapPhysicalMemory32              (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemory32            (uintptr_t addr, size_t size);
    Result  SvcGetDebugFutureThreadInfo32       (nn::svc::ilp32::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns);
    Result  SvcGetLastThreadInfo32              (nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag);
    Result  SvcGetResourceLimitLimitValue32     (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcGetResourceLimitCurrentValue32   (int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource);
    Result  SvcSetThreadActivity32              (nn::svc::Handle handle, nn::svc::ThreadActivity activity);
    Result  SvcGetThreadContext332              (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle handle);
    Result  SvcWaitForAddress32                 (uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns);
    Result  SvcSignalToAddress32                (uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num);
    void    SvcKernelDebug32                    (nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2);
    void    SvcChangeKernelTraceState32         (nn::svc::KernelTraceState state);
    Result  SvcCreateSession32                  (nn::svc::Handle* pServerSession, nn::svc::Handle* pClientSession, bool isLight, uintptr_t name);
    Result  SvcAcceptSession32                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcReplyAndReceiveLight32           (nn::svc::Handle session);
    Result  SvcReplyAndReceive32                (int32_t* pIndex, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcReplyAndReceiveWithUserBuffer32  (int32_t* pIndex, uintptr_t pMessage, size_t bufferSize, KUserPointer<const nn::svc::Handle*> pHandles, int32_t numHandle, nn::svc::Handle replyTarget, int64_t ns);
    Result  SvcCreateEvent32                    (nn::svc::Handle* pWriteHandle, nn::svc::Handle* pReadHandle);
    Result  SvcMapPhysicalMemoryUnsafe32        (uintptr_t addr, size_t size);
    Result  SvcUnmapPhysicalMemoryUnsafe32      (uintptr_t addr, size_t size);
    Result  SvcSetUnsafeLimit32                 (size_t limitSize);
    Result  SvcCreateCodeMemory32               (nn::svc::Handle* pOut, uintptr_t addr, size_t size);
    Result  SvcControlCodeMemory32              (nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission);
    void    SvcSleepSystem32                    ();
    Result  SvcReadWriteRegister32              (nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value);
    Result  SvcSetProcessActivity32             (nn::svc::Handle handle, nn::svc::ProcessActivity activity);
    Result  SvcCreateSharedMemory32             (nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission);
    Result  SvcMapTransferMemory32              (nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission);
    Result  SvcUnmapTransferMemory32            (nn::svc::Handle handle, uintptr_t addr, size_t size);
    Result  SvcCreateInterruptEvent32           (nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type);
    Result  SvcQueryPhysicalAddress32           (nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr);
    Result  SvcQueryIoMapping32                 (uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size);
    Result  SvcCreateDeviceAddressSpace32       (nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize);
    Result  SvcAttachDeviceAddressSpace32       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcDetachDeviceAddressSpace32       (nn::svc::DeviceName deviceName, nn::svc::Handle handle);
    Result  SvcMapDeviceAddressSpaceByForce32   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpaceAligned32   (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcMapDeviceAddressSpace32          (size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission);
    Result  SvcUnmapDeviceAddressSpace32        (nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress);
    Result  SvcInvalidateProcessDataCache32     (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcStoreProcessDataCache32          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcFlushProcessDataCache32          (nn::svc::Handle process, uint64_t addr, uint64_t size);
    Result  SvcDebugActiveProcess32             (nn::svc::Handle* pOut, nn::Bit64 processId);
    Result  SvcBreakDebugProcess32              (nn::svc::Handle debug);
    Result  SvcTerminateDebugProcess32          (nn::svc::Handle debug);
    Result  SvcGetDebugEvent32                  (KUserPointer<nn::svc::ilp32::DebugEventInfo*> pInfo, nn::svc::Handle debug);
    Result  SvcContinueDebugEvent32             (nn::svc::Handle debug, nn::Bit32 flags, KUserPointer<const nn::Bit64*> pThreadIds, int32_t arraySize);
    Result  SvcGetProcessList32                 (int32_t* pNumProcesses, KUserPointer<nn::Bit64*> pProcessIds, int32_t arraySize);
    Result  SvcGetThreadList32                  (int32_t* pNumThreads, KUserPointer<nn::Bit64*> pThreadIds, int32_t arraySize, nn::svc::Handle domain);
    Result  SvcGetDebugThreadContext32          (KUserPointer<nn::svc::ThreadContext*> pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags);
    Result  SvcSetDebugThreadContext32          (nn::svc::Handle debug, nn::Bit64 threadId, KUserPointer<const nn::svc::ThreadContext*> context, nn::Bit32 controlFlags);
    Result  SvcQueryDebugProcessMemory32        (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr);
    Result  SvcReadDebugProcessMemory32         (uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size);
    Result  SvcWriteDebugProcessMemory32        (nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size);
    Result  SvcSetHardwareBreakPoint32          (nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value);
    Result  SvcGetDebugThreadParam32            (nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select);
    Result  SvcGetSystemInfo32                  (nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param);
    Result  SvcCreatePort32                     (nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name);
    Result  SvcManageNamedPort32                (nn::svc::Handle* pOutServer, KUserPointer<const char*> name, int32_t maxSessions);
    Result  SvcConnectToPort32                  (nn::svc::Handle* pOut, nn::svc::Handle port);
    Result  SvcSetProcessMemoryPermission32     (nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission);
    Result  SvcMapProcessMemory32               (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcUnmapProcessMemory32             (uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size);
    Result  SvcQueryProcessMemory32             (KUserPointer<nn::svc::ilp32::MemoryInfo*> pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr);
    Result  SvcMapProcessCodeMemory32           (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcUnmapProcessCodeMemory32         (nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size);
    Result  SvcCreateProcess32                  (nn::svc::Handle* pOut, KUserPointer<const nn::svc::ilp32::CreateProcessParameter*> params, KUserPointer<const nn::Bit32*> flags, int32_t flagsNum);
    Result  SvcStartProcess32                   (nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize);
    Result  SvcTerminateProcess32               (nn::svc::Handle process);
    Result  SvcGetProcessInfo32                 (int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type);
    Result  SvcCreateResourceLimit32            (nn::svc::Handle* pOut);
    Result  SvcSetResourceLimitLimitValue32     (nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value);
    void    SvcCallSecureMonitor32              ();

} // end of namespace svc
} // end of namespace kern
} // end of namespace nn

#endif  // ifdef __cplusplus

