﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Fpu.h>
#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

#ifndef NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#error not define NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#endif

ENTRY(_ZN2nn4kern3ARM8KContext21UserModeThreadStarterEv)
    mov     r0, #0
    str     r0, [sp, #(EXCEPTION_CONTEXT_SIZE + PARAMS_ON_STACK_DISCOUNT)]
    ldr     lr, =_ZN2nn4kern3ARM13onThreadStartEv
    blx     lr

    pop     {r0-r11}
    ldm     sp, {r13-r14}^
    add     sp, sp, #8
    ldr     ip, [sp]
    mcr     p15, 0, ip, c13, c0, 2
    add     sp, sp, #8
    pop     {ip, lr}
    rfeia   sp!                 // ユーザモードの CPSR と PC を pop して分岐
SET_SIZE(_ZN2nn4kern3ARM8KContext21UserModeThreadStarterEv)

ENTRY(_ZN2nn4kern3ARM8KContext27SupervisorModeThreadStarterEv)
    pop     {r0,r1}
    mov     r2, #0
    str     r2, [sp, #(PARAMS_ON_STACK_DISCOUNT)]
    cpsie   ifa
    bx      r1
SET_SIZE(_ZN2nn4kern3ARM8KContext27SupervisorModeThreadStarterEv)

// void KContext::Save(KContext* pContext, uint32_t lr)
ENTRY(_ZN2nn4kern3ARM8KContext4SaveEPS2_m)
    // r0, r1 以外を破壊してはいけない

    push    { r12, lr }
    add     r12, sp, #8                     // 最初の sp 値を r12 に格納
    mov     lr, r1                          // lr に第 2 引数を格納

    //---- R4-11,sp,lr を保存
    stmia   r0, { r4-r11, r12, r14 }

    //----- FPEXC を保存
    fmrx    r1, fpexc
    str     r1, [r0, #KCONTEXT_FPEXC]

    pop     { r12, pc }
SET_SIZE(_ZN2nn4kern3ARM8KContext4SaveEPS2_m)

// void KContext::Restore(const KContext& pContext)
ENTRY(_ZN2nn4kern3ARM8KContext7RestoreERKS2_)
    // r2, r3 を破壊してはいけない

    //---- 排他モニタのクリア
    clrex

    //---- FPEXC を復帰
    ldr     r1, [r0, #KCONTEXT_FPEXC]
    fmxr    fpexc, r1

    //---- R4-11,sp,lr を復帰
    mov     r1, lr                          // r1 に返り先を保存
    ldmia   r0, { r4-r11, r13, r14 }

    bx      r1                              // r1 に保存しておいた返り先に返る
SET_SIZE(_ZN2nn4kern3ARM8KContext7RestoreERKS2_)

// void KContext::SaveVfp(KContext* pContext)
ENTRY(_ZN2nn4kern3ARM8KContext7SaveVfpEPS2_)
    //---- スレッドスイッチした時に VFP が無効となるように
    //---- FPEXC の EN ビットを落としておく
    ldr     r1, [r0, #KCONTEXT_FPEXC]
    bic     r1, r1, #HW_FPEXC_VFP_ENABLE
    str     r1, [r0, #KCONTEXT_FPEXC]

    //---- FPSCR 保存
    fmrx    r1, fpscr
    str     r1, [r0, #KCONTEXT_FPSCR]

    //---- VFP 数値レジスタ保存
    add     r1, r0, #KCONTEXT_FPUREGISTERS
    fstmiad r1!, { d0-d15 }
#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
    fstmiad r1!, { d16-d31 }
#endif
    bx        lr
SET_SIZE(_ZN2nn4kern3ARM8KContext7SaveVfpEPS2_)

// void KContext::RestoreVfp(const KContext& pContext)
ENTRY(_ZN2nn4kern3ARM8KContext10RestoreVfpERKS2_)
    //---- VFP 数値レジスタ復帰
    add     r1, r0, #KCONTEXT_FPUREGISTERS
    fldmiad r1!, { d0-d15 }
#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
    fldmiad r1!, { d16-d31 }
#endif

    //---- FPSCR 復帰
    ldr     r1, [r0, #KCONTEXT_FPSCR]
    fmxr    fpscr, r1

    bx        lr
SET_SIZE(_ZN2nn4kern3ARM8KContext10RestoreVfpERKS2_)

