﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace kern {
namespace init {
namespace Elf {
namespace Elf32 {
typedef uint32_t Addr;
typedef uint16_t Half;
typedef uint32_t Off;
typedef int32_t  Sword;
typedef uint32_t Word;

class Sym
{
private:
    Word            m_Name;
    Addr            m_Value;
    Word            m_Size;
    unsigned char   m_Info;
    unsigned char   m_Other;
    Half            m_Shndx;
public:
    Addr GetValue() const
    {
        return m_Value;
    }
    Word GetName() const
    {
        return m_Name;
    }
    unsigned char GetType() const
    {
        return m_Info & 0xF;
    }
    unsigned char GetBind() const
    {
        return m_Info >> 4;
    }
    unsigned char GetOther() const
    {
        return m_Other;
    }
    unsigned char GetVisibility() const
    {
        return GetOther() & 0x3;
    }
    Half GetShndx() const
    {
        return m_Shndx;
    }
    Word GetSize() const
    {
        return m_Size;
    }
};

class Rel
{
private:
    Addr    m_Offset;
    Word    m_Info;
public:
    Word    GetSym() const
    {
        return m_Info >> 8;
    }
    Word    GetType() const
    {
        return static_cast<unsigned char>(m_Info);
    }
    Addr    GetOffset() const
    {
        return m_Offset;
    }
};

class Rela
{
private:
    Addr    m_Offset;
    Word    m_Info;
    Addr    m_Addend;
public:
    Word    GetSym() const
    {
        return m_Info >> 8;
    }
    Word    GetType() const
    {
        return static_cast<unsigned char>(m_Info);
    }
    Addr    GetOffset() const
    {
        return m_Offset;
    }
    Addr    GetAddend() const
    {
        return m_Addend;
    }
};


class Dyn
{
private:
    Sword   m_Tag;
    union
    {
        Word val;
        Addr ptr;
    } m_Un;
public:
    Sword GetTag() const
    {
        return m_Tag;
    }
    Addr GetPtr() const
    {
        return m_Un.ptr;
    }
    Word GetVal() const
    {
        return m_Un.val;
    }
};

#if defined NN_BUILD_CONFIG_CPU_ARM
namespace aarch32 {
enum RelocationCode
{
    R_NONE          = 0,
    R_ABS32         = 2,
    R_TLS_DESC      = 13,
    R_TLS_DTPMOD32  = 17,
    R_TLS_DTPOFF32  = 18,
    R_TLS_TPOFF32   = 19,
    R_GLOB_DAT      = 21,
    R_JUMP_SLOT     = 22,
    R_RELATIVE      = 23
};
}
using namespace nn::kern::init::Elf::Elf32::aarch32;
#endif
}
}
}
}}
