﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "../kern_Platform.h"
#include "kern_InitElf.h"

namespace nn { namespace kern { namespace init { namespace Elf {
extern "C"
{
    extern void (*__init_array_start []) ();
    extern void (*__init_array_end []) ();
}

void Setup(uintptr_t base, const nn::kern::init::Elf::Dyn* pDynamicSection)
{
    size_t relEnt = 0;
    size_t relaEnt = 0;
    size_t relCount = 0;
    size_t relaCount = 0;
    uintptr_t dynRel = 0;
    uintptr_t dynRela = 0;

    for (const nn::kern::init::Elf::Dyn* pDyn = pDynamicSection; pDyn->GetTag() != nn::kern::init::Elf::DT_NULL; pDyn++)
    {
        if (pDyn->GetTag() == nn::kern::init::Elf::DT_REL)
        {
            dynRel = base + pDyn->GetPtr();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELA)
        {
            dynRela = base + pDyn->GetPtr();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELENT)
        {
            relEnt = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELAENT)
        {
            relaEnt = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELCOUNT)
        {
            relCount = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELACOUNT)
        {
            relaCount = pDyn->GetVal();
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELENT)
        {
            while (pDyn->GetVal() != sizeof(nn::kern::init::Elf::Rel)) {}
        }
        else if (pDyn->GetTag() == nn::kern::init::Elf::DT_RELAENT)
        {
            while (pDyn->GetVal() != sizeof(nn::kern::init::Elf::Rela)) {}
        }
    }

    for (size_t i = 0; i < relCount; i++)
    {
        nn::kern::init::Elf::Rel& rel = *reinterpret_cast<nn::kern::init::Elf::Rel*>(dynRel + relEnt * i);
        while (rel.GetType() != nn::kern::init::Elf::R_RELATIVE) {}
        nn::kern::init::Elf::Addr* pTarget = reinterpret_cast<nn::kern::init::Elf::Addr*>(base + rel.GetOffset());
        *pTarget += base;
    }

    for (size_t i = 0; i < relaCount; i++)
    {
        nn::kern::init::Elf::Rela& rela = *reinterpret_cast<nn::kern::init::Elf::Rela*>(dynRela + relaEnt * i);
        while (rela.GetType() != nn::kern::init::Elf::R_RELATIVE) {}
        nn::kern::init::Elf::Addr* pTarget = reinterpret_cast<nn::kern::init::Elf::Addr*>(base + rela.GetOffset());
        *pTarget = base + rela.GetAddend();
    }

    for (void (**f)() = __init_array_start; f < __init_array_end; ++f)
    {
        (*f)();
    }
}

}}}}

