﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include <nn/svc/svc_Kernel.h>
#include "../../kern_KPageGroup.h"

namespace nn { namespace kern { namespace smma53 {

typedef uint64_t KDeviceVirtualAddress;

class KDevicePageTable
{
public:
    Result Initialize(uint64_t spaceAddress, uint64_t spaceSize)
    {
        NN_UNUSED(spaceAddress);
        NN_UNUSED(spaceSize);
        return nn::svc::ResultNotImplemented();
    }
    Result Attach(nn::svc::DeviceName deviceName, uint64_t spaceAddress, uint64_t spaceSize)
    {
        NN_UNUSED(deviceName);
        NN_UNUSED(spaceAddress);
        NN_UNUSED(spaceSize);
        return nn::svc::ResultNotImplemented();
    }
    Result Detach(nn::svc::DeviceName deviceName)
    {
        NN_UNUSED(deviceName);
        return nn::svc::ResultNotImplemented();
    }
    Result Map(size_t* pMapSize, const KPageGroup& pageGroup, KDeviceVirtualAddress deviceAddress, nn::svc::MemoryPermission devicePermission, bool breakAllocate)
    {
        NN_UNUSED(pMapSize);
        NN_UNUSED(pageGroup);
        NN_UNUSED(deviceAddress);
        NN_UNUSED(devicePermission);
        NN_UNUSED(breakAllocate);
        return nn::svc::ResultNotImplemented();
    }
    Result Unmap(const KPageGroup& pageGroup, KDeviceVirtualAddress deviceAddress)
    {
        NN_UNUSED(pageGroup);
        NN_UNUSED(deviceAddress);
        return nn::svc::ResultNotImplemented();
    }
    void Finalize() {}
    static void Initialize() {}
};

}}} // namespace

