﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

#include "kern_MemoryMapDetail.h"
#include "kern_MemoryMapHardware.h"
#include "../../ip/ARMv7A/kern_MemoryMapCpu.h"

#define NN_KERN_P_ADDR_MAIN_MEMORY              NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY
#define NN_KERN_P_ADDR_MAIN_MEMORY_SIZE         NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE
#define NN_KERN_P_ADDR_MAIN_MEMORY_END          NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END

#define NN_KERN_P_ADDR_RESERVED_LO_SIZE         NN_KERN_DETAIL_P_ADDR_RESERVED_LO_SIZE
#define NN_KERN_P_ADDR_RESERVED_HI_SIZE         NN_KERN_DETAIL_P_ADDR_RESERVED_HI_SIZE

#define NN_KERN_P_ADDR_UART_REGISTER            NN_KERN_DETAIL_P_ADDR_UART0_REGISTER

#define NN_KERN_V_ADDR_UART_REGISTER            NN_KERN_DETAIL_V_ADDR_UART0_REGISTER
#define NN_KERN_V_ADDR_UART_REGISTER_END        NN_KERN_DETAIL_V_ADDR_UART0_REGISTER_END

#define NN_KERN_P_ADDR_MC_REGISTER              NN_KERN_DETAIL_P_ADDR_MC_REGISTER
#define NN_KERN_P_ADDR_MC_REGISTER_SIZE         NN_KERN_DETAIL_P_ADDR_MC_REGISTER_SIZE
#define NN_KERN_P_ADDR_MC_REGISTER_END          NN_KERN_DETAIL_P_ADDR_MC_REGISTER_END
#define NN_KERN_V_ADDR_MC_REGISTER              NN_KERN_DETAIL_V_ADDR_MC_REGISTER
#define NN_KERN_V_ADDR_MC_REGISTER_END          NN_KERN_DETAIL_V_ADDR_MC_REGISTER_END

#define NN_KERN_P_ADDR_GIC_DISTRIBUTER          NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER
#define NN_KERN_P_ADDR_GIC_DISTRIBUTER_SIZE     NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_SIZE
#define NN_KERN_P_ADDR_GIC_DISTRIBUTER_END      NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_END
#define NN_KERN_P_ADDR_CPU_INTERFACE            NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE
#define NN_KERN_P_ADDR_CPU_INTERFACE_SIZE       NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_SIZE
#define NN_KERN_P_ADDR_CPU_INTERFACE_END        NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_END

#define NN_KERN_P_ADDR_CORE_PRIVATE_REGION      NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION
#define NN_KERN_P_ADDR_CORE_PRIVATE_REGION_SIZE NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_SIZE
#define NN_KERN_P_ADDR_CORE_PRIVATE_REGION_END  NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_END
#define NN_KERN_V_ADDR_CORE_PRIVATE_REGION      NN_KERN_DETAIL_V_ADDR_CORE_PRIVATE_REGION
#define NN_KERN_V_ADDR_CORE_PRIVATE_REGION_SIZE NN_KERN_DETAIL_V_ADDR_CORE_PRIVATE_REGION_SIZE
#define NN_KERN_V_ADDR_CORE_PRIVATE_REGION_END  NN_KERN_DETAIL_V_ADDR_CORE_PRIVATE_REGION_END

