﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnc/socket/socket_TypesPrivate.h>

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

int              nnsocketDuplicateSocket(int socket, uint64_t ownerProcessId);

struct hostent* nnsocketGetHostByNameWithOptions(const char* pName,
                                                 const struct nnsocketResolverOption* options,
                                                 size_t optionCount);

struct hostent* nnsocketGetHostByAddrWithOptions(const void* pAddress,
                                                 socklen_t length,
                                                 int addressFamily,
                                                 const struct nnsocketResolverOption* options,
                                                 size_t optionCount);

int nnsocketGetAddrInfoWithOptions(const char* pNodeName,
                                   const char* pServerName,
                                   const struct addrinfo* pHints,
                                   struct addrinfo** pResult,
                                   const struct nnsocketResolverOption* options,
                                   size_t optionCount);

int nnsocketGetNameInfoWithOptions(const struct sockaddr* socketAddress,
                                   socklen_t socketAddressLength,
                                   char* host, socklen_t hostLength,
                                   char* service, socklen_t serviceLength,
                                   int flags,
                                   const struct nnsocketResolverOption* options, size_t optionCount);

#ifdef __cplusplus
}
#endif // __cplusplus
