﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nnc/nn_Result.h>
#include <nnc/socket/socket_Types.h>
#include <nnc/socket/socket_Constants.h>
#include <nnc/socket/socket_TypesPrivate.h>

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

ssize_t  nnsocketRecv(int socket, void* outBuffer, size_t outBufferLength, int flags);
ssize_t  nnsocketRecvFrom(int socket, void* outBuffer, size_t outBufferLength, int flags, struct sockaddr* pOutAddress, socklen_t* pOutAddressLength);
ssize_t  nnsocketSend(int socket, const void* buffer, size_t bufferLength, int flags);
ssize_t  nnsocketSendTo(int socket, const void* buffer, size_t bufferLength, int flags, const struct sockaddr* pAddress, socklen_t addressLength);
ssize_t  nnsocketRecvMsg(int socket, struct msghdr* pOutMessage, int flags);
ssize_t  nnsocketSendMsg(int socket, const struct msghdr* pMessage, int flags);
uint16_t nnsocketInetHtons(uint16_t hostValue);
uint32_t nnsocketInetHtonl(uint32_t hostValue);
uint16_t nnsocketInetNtohs(uint16_t networkValue);
uint32_t nnsocketInetNtohl(uint32_t networkValue);
int      nnsocketAccept(int socket, struct sockaddr* pOutAddress, socklen_t* pOutAddressLength);
int      nnsocketBind(int socket, const struct sockaddr* pAddress, socklen_t addressLength);
int      nnsocketConnect(int socket, const struct sockaddr* pAddress, socklen_t addressLength);
int      nnsocketGetPeerName(int socket, struct sockaddr* pOutAddress, socklen_t* pOutAddressLength);
int      nnsocketGetSockName(int socket, struct sockaddr* pOutAddress, socklen_t* pOutAddressLength);
int      nnsocketGetSockOpt(int socket, int level, int optionName, void* pOutOptionValue, socklen_t* pOutOptionLength);
int      nnsocketListen(int socket, int backlog);
int      nnsocketSetSockOpt(int socket, int level, int optionName, const void* pOptionValue, socklen_t optionLength);
int      nnsocketSockAtMark(int socket);
int      nnsocketShutdown(int socket, int how);
int      nnsocketSocket(int domain, int type, int protocol);
int      nnsocketWrite(int socket, const void* buffer, size_t bufferLength);
int      nnsocketRead(int socket, void* outBuffer, size_t outBufferLength);
int      nnsocketClose(int socket);
int      nnsocketSelect(int numberOfDescriptors, fd_set*  pReadDescriptors, fd_set*  pWriteDescriptors, fd_set*  pExceptDescriptors, struct timeval* pTimeout);
int      nnsocketPoll(struct pollfd* pSocketDescriptors, nfds_t numberOfDescriptors, int timeoutMilliseconds);
int      nnsocketFcntl(int socket, int command, ...);
int      nnsocketInetPton(int family, const char* pAddressString, void* pOutAddressBuffer);
int      nnsocketGetLastErrno();
void     nnsocketSetLastErrno(int error);
int      nnsocketIoctl(int socket, uint32_t command, void* pData, size_t dataLength);
int      nnsocketOpen(const char* path, int flags);
int      nnsocketInetAton(const char* addressStringBuffer, struct in_addr* pOutNetworkAddress);
const char* nnsocketInetNtop(int family, const void* pNetworkAddress, char* addressStringBuffer, socklen_t addressStringBufferLength);
char*    nnsocketInetNtoa(struct in_addr networkAddress);
int *    nnsocketGetHErrno();
struct hostent* nnsocketGetHostByName(const char* pName);
struct hostent* nnsocketGetHostByAddr(const void* pAddress, socklen_t length, int addressFamily);
const char* nnsocketHStrError(int errorNumber);
int      nnsocketGetAddrInfo(const char* pNodeName, const char* pServerName, const struct addrinfo* pHints, struct addrinfo** pResult);
void     nnsocketFreeAddrInfo(struct addrinfo* addrInfoStorage);
int nnsocketResolverGetOption(nnsocketResolverOption* pOptionOut, nnsocketResolverOptionKey key);
int nnsocketResolverSetOption(const nnsocketResolverOption* pOption);
const char* nnsocketGAIStrError(int errorCode);
int      nnsocketGetNameInfo(const struct sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags);
int      nnsocketSysctl(int* pMibEntries, size_t mibEntryCount, void* pOldValue, size_t* pOldValueLength, void* pNewValue, size_t newValueLength);
nnResult nnsocketInitialize(void* memoryPool, size_t memoryPoolSize, size_t allocatorPoolSize, int concurrencyLimit);
nnResult nnsocketFinalize();
NN_DEPRECATED nnResult nnsocketInitializeWithDefaultHeap();

#ifdef __cplusplus
}
#endif // __cplusplus
