﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   OS-API 内部実装用のメモリフェンスの定義（Win32 版）
 */

#pragma once

#pragma warning( push )
#pragma warning ( disable : 4668 )
#include <intrin.h>
#pragma warning( pop )

#include <nn/os/os_Config.h>

#include <nnc/nn_Common.h>
#include <nnc/nn_Macro.h>

#define NNC_OS_DETAIL_SFENCE()   do { _WriteBarrier(); _mm_sfence(); } while (NNC_STATIC_CONDITION(0))
#define NNC_OS_DETAIL_LFENCE()   do { _WriteBarrier(); _mm_lfence(); } while (NNC_STATIC_CONDITION(0))
#define NNC_OS_DETAIL_MFENCE()   do { _WriteBarrier(); _mm_mfence(); } while (NNC_STATIC_CONDITION(0))

//--------------------------------------------------------------------------

#ifndef __cplusplus

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryStoreStore()
{
    NNC_OS_DETAIL_SFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryStoreLoad()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryStoreAny()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryLoadStore()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryLoadLoad()
{
    NNC_OS_DETAIL_LFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryLoadAny()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryAnyStore()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryAnyLoad()
{
    NNC_OS_DETAIL_MFENCE();
}

NN_OS_EXTERN_C NNC_FORCEINLINE void nnosdetailFenceMemoryAnyAny()
{
    NNC_OS_DETAIL_MFENCE();
}

#endif // __cplusplus

//--------------------------------------------------------------------------
