﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向け I/O マッピングに関する C 言語用公開ヘッダファイル
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/dd/dd_Macro.h>
#include <nnc/dd/dd_PhysicalAddress.h>

//--------------------------------------------------------------------------
//  for C
//--------------------------------------------------------------------------

//! @name I/O マッピング関連 API
//! @{

/**
 * @brief   I/O レジスタがマッピングされている仮想アドレスを得ます
 *
 * @details
 *  詳細は nn::dd::QueryIoMappingAddress() を参照してください。
 *
 */
NN_DD_EXTERN_C uintptr_t nnddQueryIoMappingAddress(nnddPhysicalAddress physicalAddress, size_t size);

//! @}

