﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向けキャッシュ操作に関する C 言語用公開ヘッダファイル
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/dd/dd_Macro.h>

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

//! @name キャッシュ操作関連 API
//! @{

/**
 * @brief   データキャッシュを破棄します。
 *
 * @details
 *  詳細は nn::dd::InvalidateDataCache() を参照してください。
 */
NN_DD_EXTERN_C void nnddInvalidateDataCache( void* addr, size_t size );

/**
 * @brief   データキャッシュをメモリに書き出します。
 *
 * @details
 *  詳細は nn::dd::StoreDataCache() を参照してください。
 */
NN_DD_EXTERN_C void nnddStoreDataCache( const void* addr, size_t size );

/**
 * @brief   データキャッシュをメモリに書き出したのち破棄します。
 *
 * @details
 *  詳細は nn::dd::FlushDataCache() を参照してください。
 */
NN_DD_EXTERN_C void nnddFlushDataCache( const void* addr, size_t size );

//! @}

