﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Result.h>

namespace nn { namespace tsc {

const int g_MaxInterfaceNameLength = 32;
const int g_Ipv4AddrLength         = 4;
const int g_MinMtuSize             = 576;
const int g_MaxMtuSize             = 1500;

//--------------------------------------------------------------------------
/**
*   @brief      Bit mask to specifiy the mode of the way to initialize network stack
*
*   @details
*       Optional value which can be passed to @ref modeMask in @ref ApplyIpConfig.
*
*/
enum IpApplyModeMask
{
    IpApplyModeMask_None             = 0x00, //!< No mask
    IpApplyModeMask_DuplicateIpCheck = 0x01, //!< Performs duplicate IP check after IP is configured
};

//--------------------------------------------------------------------------
/**
*   @brief      IPv4 configuration method
*
*   @details
*       IPv4 configuration method .
*/
enum Ipv4ConfigMethod
{
    Ipv4ConfigMethod_Static,     //!< Full manual IP address configuration
    Ipv4ConfigMethod_DhcpHybrid, //!< DHCP IP address cofiguration and manual DNS addresses configuration
    Ipv4ConfigMethod_Dhcp        //!< Full DHCP IP address configuration
};

//--------------------------------------------------------------------------
/**
*   @brief      Storage for IPv4 address
*/
typedef struct Ipv4AddrStorage
{
    uint32_t storage;
} Ipv4AddrStorage;

//--------------------------------------------------------------------------
/**
*   @brief      Strcuture of IPv4 information passed to @ref SetIpv4Config or @ref GetIpv4Config
*/
typedef struct Ipv4Config
{
    Ipv4ConfigMethod method;           //!< IPv4 address configuration method
    Ipv4AddrStorage  interfaceAddress; //!< Network interface address
    Ipv4AddrStorage  subnetMask;       //!< Subnet mask
    Ipv4AddrStorage  defaultGateway;   //!< Default gateway address
    Ipv4AddrStorage  preferredDns;     //!< Preferred DNS address
    Ipv4AddrStorage  alternativeDns;   //!< Alternative DNS address
} Ipv4Config;

}}
