﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Result.h>

#include <nn/tsc/tsc_Types.h>

namespace nn { namespace tsc {

//--------------------------------------------------------------------------
/**
*   @brief      Initialize TSC library.
*   @pre
*   @post       User needs to finalize the library by @ref Finalize after finishes using it.
*
*   @return     Result of the process is returned
*   @retval     ResultSuccess                 Success or TSC library is already initialized
*   @retval     ResultInternalModuleFailed    Failed to initialize necessary modules
*/
Result Initialize() NN_NOEXCEPT;

//--------------------------------------------------------------------------
/**
*   @brief      Finalize TSC library.
*   @pre        User has already called tsc::Initialize and there's no ongoing configuration
*               process requested by @ref ApplyConfig.
*   @post
*
*   @return     Result of the process is returned
*   @retval     ResultSuccess                    Success
*   @retval     ResultLibraryNotInitialized      TSC library is not initialized yet
*   @retval     ResultConfigurationInProgress    There's ongoing config operation
*   @retval     ResultInternalModuleFailed       Failed to initialize necessary modules
*/
Result Finalize() NN_NOEXCEPT;
}}
