﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/htcs/htcs_Types.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace tma { // NOLINT(whitespace/braces)

class IHtcsManager;

class ISocket;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IHtcsManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IHtcsManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutSocket))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t backlogCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::int32_t descriptor))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t descriptor, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::int32_t descriptor, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t how))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t command, ::std::int32_t value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerNameAny, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultHostName, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocketOld, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessId, (::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MonitorManager, (::nn::Bit64 processId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IHtcsManager)

        ::nn::Result Socket(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutSocket) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Socket, (pOutErrorCode, pOutSocket));
        }

        ::nn::Result Close(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Close, (pOutErrorCode, pOutIntResult, descriptor));
        }

        ::nn::Result Connect(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (pOutErrorCode, pOutIntResult, descriptor, address));
        }

        ::nn::Result Bind(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Bind, (pOutErrorCode, pOutIntResult, descriptor, address));
        }

        ::nn::Result Listen(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t backlogCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Listen, (pOutErrorCode, pOutIntResult, descriptor, backlogCount));
        }

        ::nn::Result Accept(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::int32_t descriptor) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Accept, (pOutErrorCode, pOutIntResult, pOutAddress, descriptor));
        }

        ::nn::Result Recv(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t descriptor, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Recv, (pOutErrorCode, pOutReceivedSize, buffer, descriptor, flags));
        }

        ::nn::Result Send(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::int32_t descriptor, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Send, (pOutErrorCode, pOutSentSize, descriptor, buffer, flags));
        }

        ::nn::Result Shutdown(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t how) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Shutdown, (pOutErrorCode, pOutIntResult, descriptor, how));
        }

        ::nn::Result Fcntl(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t command, ::std::int32_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Fcntl, (pOutErrorCode, pOutIntResult, descriptor, command, value));
        }

        ::nn::Result GetPeerNameAny(::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPeerNameAny, (pOutValue));
        }

        ::nn::Result GetDefaultHostName(::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDefaultHostName, (pOutValue));
        }

        ::nn::Result CreateSocketOld(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSocketOld, (pOutErrorCode, pOutSocket));
        }

        ::nn::Result CreateSocket(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSocket, (pOutErrorCode, pOutSocket, enableDisconnectionEmulation));
        }

        ::nn::Result RegisterProcessId(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterProcessId, (processId));
        }

        ::nn::Result MonitorManager(::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MonitorManager, (processId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IHtcsManager
    {
    public:
        nn::Result Socket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutSocket) NN_NOEXCEPT;
        nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor) NN_NOEXCEPT;
        nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
        nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
        nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t backlogCount) NN_NOEXCEPT;
        nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::int32_t descriptor) NN_NOEXCEPT;
        nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t descriptor, std::int32_t flags) NN_NOEXCEPT;
        nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::int32_t descriptor, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
        nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t how) NN_NOEXCEPT;
        nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t command, std::int32_t value) NN_NOEXCEPT;
        nn::Result GetPeerNameAny(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT;
        nn::Result GetDefaultHostName(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT;
        nn::Result CreateSocketOld(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket) NN_NOEXCEPT;
        nn::Result CreateSocket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation) NN_NOEXCEPT;
        nn::Result RegisterProcessId(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result MonitorManager(nn::Bit64 processId) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Socket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutSocket) NN_NOEXCEPT;
    nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor) NN_NOEXCEPT;
    nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t backlogCount) NN_NOEXCEPT;
    nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::int32_t descriptor) NN_NOEXCEPT;
    nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t descriptor, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::int32_t descriptor, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t how) NN_NOEXCEPT;
    nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t command, std::int32_t value) NN_NOEXCEPT;
    nn::Result GetPeerNameAny(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT;
    nn::Result GetDefaultHostName(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT;
    nn::Result CreateSocketOld(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket) NN_NOEXCEPT;
    nn::Result CreateSocket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation) NN_NOEXCEPT;
    nn::Result RegisterProcessId(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result MonitorManager(nn::Bit64 processId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::tma::IHtcsManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutSocket))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Socket, (pOutErrorCode, pOutSocket));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Close, (pOutErrorCode, pOutIntResult, descriptor));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (pOutErrorCode, pOutIntResult, descriptor, address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Bind, (pOutErrorCode, pOutIntResult, descriptor, address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t backlogCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Listen, (pOutErrorCode, pOutIntResult, descriptor, backlogCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::int32_t descriptor))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Accept, (pOutErrorCode, pOutIntResult, pOutAddress, descriptor));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t descriptor, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Recv, (pOutErrorCode, pOutReceivedSize, buffer, descriptor, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::int32_t descriptor, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Send, (pOutErrorCode, pOutSentSize, descriptor, buffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t how))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Shutdown, (pOutErrorCode, pOutIntResult, descriptor, how));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t command, ::std::int32_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Fcntl, (pOutErrorCode, pOutIntResult, descriptor, command, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerNameAny, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPeerNameAny, (pOutValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultHostName, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDefaultHostName, (pOutValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocketOld, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSocketOld, (pOutErrorCode, pOutSocket));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSocket, (pOutErrorCode, pOutSocket, enableDisconnectionEmulation));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessId, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterProcessId, (processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MonitorManager, (::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MonitorManager, (processId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::tma::IHtcsManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::tma::IHtcsManager))

    // nn::Result Socket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutSocket) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Socket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSocket, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutSocket))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSocket)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Socket)

    // nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Close)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (descriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Close)

    // nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::htcs::SockAddrHtcs), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (address, descriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Bind)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::htcs::SockAddrHtcs), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (address, descriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Bind)

    // nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t backlogCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Listen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(backlogCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (descriptor, backlogCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(backlogCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Listen)

    // nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::int32_t descriptor) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Accept)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (descriptor))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddress, (::nn::htcs::SockAddrHtcs), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 68)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pOutAddress, pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(76)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Accept)

    // nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t descriptor, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Recv)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (descriptor, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReceivedSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutReceivedSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReceivedSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Recv)

    // nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::int32_t descriptor, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Send)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (descriptor, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSentSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutSentSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSentSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Send)

    // nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t how) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Shutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(how, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (descriptor, how))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(how)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Shutdown)

    // nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t command, std::int32_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Fcntl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descriptor, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(command, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (descriptor, command, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descriptor), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(command), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Fcntl)

    // nn::Result GetPeerNameAny(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPeerNameAny)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutValue, (::nn::htcs::HtcsPeerName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPeerNameAny)

    // nn::Result GetDefaultHostName(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDefaultHostName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutValue, (::nn::htcs::HtcsPeerName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDefaultHostName)

    // nn::Result CreateSocketOld(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSocketOld)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutSocket, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutSocket))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutErrorCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSocket)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSocketOld)

    // nn::Result CreateSocket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSocket)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutSocket, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutSocket))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enableDisconnectionEmulation, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enableDisconnectionEmulation))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutErrorCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSocket), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enableDisconnectionEmulation)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSocket)

    // nn::Result RegisterProcessId(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterProcessId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterProcessId)

    // nn::Result MonitorManager(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MonitorManager)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MonitorManager)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::htcs::SockAddrHtcs), 66, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::htcs::HtcsPeerName), 32, 2)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::tma::IHtcsManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::tma::IHtcsManager))

    // nn::Result Socket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutSocket) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Socket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutSocket))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Socket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSocket)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Socket)
    }

    // nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Close)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Close)
    }

    // nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Bind)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Bind)
    }

    // nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t backlogCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t backlogCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Listen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(backlogCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Listen)
    }

    // nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::int32_t descriptor) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::int32_t descriptor))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Accept)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Accept)
    }

    // nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t descriptor, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t descriptor, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Recv)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReceivedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Recv)
    }

    // nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::int32_t descriptor, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::int32_t descriptor, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Send)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSentSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Send)
    }

    // nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t how) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t how))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Shutdown)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(how)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Shutdown)
    }

    // nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t descriptor, std::int32_t command, std::int32_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t descriptor, ::std::int32_t command, ::std::int32_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Fcntl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descriptor)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(command)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Fcntl)
    }

    // nn::Result GetPeerNameAny(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPeerNameAny, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPeerNameAny)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPeerNameAny)
    }

    // nn::Result GetDefaultHostName(nn::sf::Out<nn::htcs::HtcsPeerName> pOutValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDefaultHostName, (::nn::sf::Out<::nn::htcs::HtcsPeerName> pOutValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDefaultHostName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDefaultHostName)
    }

    // nn::Result CreateSocketOld(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocketOld, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSocketOld)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSocket)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSocketOld)
    }

    // nn::Result CreateSocket(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSocket, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, bool enableDisconnectionEmulation))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSocket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSocket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enableDisconnectionEmulation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSocket)
    }

    // nn::Result RegisterProcessId(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterProcessId, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterProcessId)
    }

    // nn::Result MonitorManager(nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MonitorManager, (::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MonitorManager)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MonitorManager)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::tma::IHtcsManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::tma::IHtcsManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Socket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Socket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Close)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Bind)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Listen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(backlogCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Accept)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Recv)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReceivedSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Send)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSentSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Shutdown)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(how)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Fcntl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descriptor),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(command),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPeerNameAny)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPeerNameAny)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDefaultHostName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDefaultHostName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSocketOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::tma::ISocket>), pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSocketOld)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutSocket, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::tma::ISocket>), pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSocket)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutSocket),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enableDisconnectionEmulation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutSocket, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterProcessId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MonitorManager)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MonitorManager)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Socket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPeerNameAny)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDefaultHostName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSocketOld)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MonitorManager)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::tma::IHtcsManager))

namespace nn { namespace tma { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISocket, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISocket)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t backlogCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t how))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t command, ::std::int32_t value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcceptStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcceptResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::uint32_t TaskId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RecvStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t memorySize, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RecvResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t TaskId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RecvLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t unalignedRecvSizeStart, ::std::int32_t unalignedRecvSizeEnd, ::std::int64_t alignedSendSize, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& startBuffer, const ::nn::sf::InBuffer& endBuffer, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int64_t alignedSendSize, ::std::int32_t flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::uint32_t TaskId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISocket)

        ::nn::Result Close(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Close, (pOutErrorCode, pOutIntResult));
        }

        ::nn::Result Connect(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (pOutErrorCode, pOutIntResult, address));
        }

        ::nn::Result Bind(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Bind, (pOutErrorCode, pOutIntResult, address));
        }

        ::nn::Result Listen(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t backlogCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Listen, (pOutErrorCode, pOutIntResult, backlogCount));
        }

        ::nn::Result Accept(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Accept, (pOutErrorCode, pOutSocket, pOutAddress));
        }

        ::nn::Result Recv(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Recv, (pOutErrorCode, pOutReceivedSize, buffer, flags));
        }

        ::nn::Result Send(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Send, (pOutErrorCode, pOutSentSize, buffer, flags));
        }

        ::nn::Result Shutdown(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t how) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Shutdown, (pOutErrorCode, pOutIntResult, how));
        }

        ::nn::Result Fcntl(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t command, ::std::int32_t value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Fcntl, (pOutErrorCode, pOutIntResult, command, value));
        }

        ::nn::Result AcceptStart(::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcceptStart, (pTaskId, pWaitHandle));
        }

        ::nn::Result AcceptResults(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::uint32_t TaskId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcceptResults, (pOutErrorCode, pOutSocket, pOutAddress, TaskId));
        }

        ::nn::Result RecvStart(::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t memorySize, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RecvStart, (pTaskId, pWaitHandle, memorySize, flags));
        }

        ::nn::Result RecvResults(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t TaskId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RecvResults, (pOutErrorCode, pOutReceivedSize, buffer, TaskId));
        }

        ::nn::Result RecvLargeStart(::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t unalignedRecvSizeStart, ::std::int32_t unalignedRecvSizeEnd, ::std::int64_t alignedSendSize, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RecvLargeStart, (pTaskId, pWaitHandle, unalignedRecvSizeStart, unalignedRecvSizeEnd, alignedSendSize, ::std::move(alignedMemoryHandle), flags));
        }

        ::nn::Result SendStart(::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendStart, (pTaskId, pWaitHandle, buffer, flags));
        }

        ::nn::Result SendLargeStart(::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& startBuffer, const ::nn::sf::InBuffer& endBuffer, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int64_t alignedSendSize, ::std::int32_t flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendLargeStart, (pTaskId, pWaitHandle, startBuffer, endBuffer, ::std::move(alignedMemoryHandle), alignedSendSize, flags));
        }

        ::nn::Result SendResults(::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::uint32_t TaskId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendResults, (pOutErrorCode, pOutSentSize, TaskId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISocket
    {
    public:
        nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult) NN_NOEXCEPT;
        nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
        nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
        nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t backlogCount) NN_NOEXCEPT;
        nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT;
        nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
        nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
        nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t how) NN_NOEXCEPT;
        nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t command, std::int32_t value) NN_NOEXCEPT;
        nn::Result AcceptStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle) NN_NOEXCEPT;
        nn::Result AcceptResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::uint32_t TaskId) NN_NOEXCEPT;
        nn::Result RecvStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t memorySize, std::int32_t flags) NN_NOEXCEPT;
        nn::Result RecvResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::uint32_t TaskId) NN_NOEXCEPT;
        nn::Result RecvLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t unalignedRecvSizeStart, std::int32_t unalignedRecvSizeEnd, std::int64_t alignedSendSize, nn::sf::NativeHandle&& alignedMemoryHandle, std::int32_t flags) NN_NOEXCEPT;
        nn::Result SendStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
        nn::Result SendLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& startBuffer, const nn::sf::InBuffer& endBuffer, nn::sf::NativeHandle&& alignedMemoryHandle, std::int64_t alignedSendSize, std::int32_t flags) NN_NOEXCEPT;
        nn::Result SendResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::uint32_t TaskId) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult) NN_NOEXCEPT;
    nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT;
    nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t backlogCount) NN_NOEXCEPT;
    nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT;
    nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t how) NN_NOEXCEPT;
    nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t command, std::int32_t value) NN_NOEXCEPT;
    nn::Result AcceptStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle) NN_NOEXCEPT;
    nn::Result AcceptResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::uint32_t TaskId) NN_NOEXCEPT;
    nn::Result RecvStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t memorySize, std::int32_t flags) NN_NOEXCEPT;
    nn::Result RecvResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::uint32_t TaskId) NN_NOEXCEPT;
    nn::Result RecvLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t unalignedRecvSizeStart, std::int32_t unalignedRecvSizeEnd, std::int64_t alignedSendSize, nn::sf::NativeHandle&& alignedMemoryHandle, std::int32_t flags) NN_NOEXCEPT;
    nn::Result SendStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT;
    nn::Result SendLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& startBuffer, const nn::sf::InBuffer& endBuffer, nn::sf::NativeHandle&& alignedMemoryHandle, std::int64_t alignedSendSize, std::int32_t flags) NN_NOEXCEPT;
    nn::Result SendResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::uint32_t TaskId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::tma::ISocket))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Close, (pOutErrorCode, pOutIntResult));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (pOutErrorCode, pOutIntResult, address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Bind, (pOutErrorCode, pOutIntResult, address));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t backlogCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Listen, (pOutErrorCode, pOutIntResult, backlogCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Accept, (pOutErrorCode, pOutSocket, pOutAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Recv, (pOutErrorCode, pOutReceivedSize, buffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Send, (pOutErrorCode, pOutSentSize, buffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t how))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Shutdown, (pOutErrorCode, pOutIntResult, how));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t command, ::std::int32_t value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Fcntl, (pOutErrorCode, pOutIntResult, command, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcceptStart, (pTaskId, pWaitHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::uint32_t TaskId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcceptResults, (pOutErrorCode, pOutSocket, pOutAddress, TaskId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t memorySize, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RecvStart, (pTaskId, pWaitHandle, memorySize, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t TaskId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RecvResults, (pOutErrorCode, pOutReceivedSize, buffer, TaskId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t unalignedRecvSizeStart, ::std::int32_t unalignedRecvSizeEnd, ::std::int64_t alignedSendSize, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RecvLargeStart, (pTaskId, pWaitHandle, unalignedRecvSizeStart, unalignedRecvSizeEnd, alignedSendSize, ::std::move(alignedMemoryHandle), flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendStart, (pTaskId, pWaitHandle, buffer, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& startBuffer, const ::nn::sf::InBuffer& endBuffer, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int64_t alignedSendSize, ::std::int32_t flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendLargeStart, (pTaskId, pWaitHandle, startBuffer, endBuffer, ::std::move(alignedMemoryHandle), alignedSendSize, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::uint32_t TaskId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendResults, (pOutErrorCode, pOutSentSize, TaskId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::tma::ISocket>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::tma::ISocket))

    // nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Close)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Close)

    // nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::htcs::SockAddrHtcs), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(66)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Bind)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(address, (::nn::htcs::SockAddrHtcs), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (address))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(66)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(address)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Bind)

    // nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t backlogCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Listen)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(backlogCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (backlogCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(backlogCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Listen)

    // nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Accept)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutSocket, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutSocket))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddress, (::nn::htcs::SockAddrHtcs), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutAddress, pOutErrorCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSocket), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Accept)

    // nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Recv)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReceivedSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutReceivedSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReceivedSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Recv)

    // nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Send)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSentSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutSentSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSentSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Send)

    // nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t how) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Shutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(how, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (how))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(how)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Shutdown)

    // nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t command, std::int32_t value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Fcntl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(command, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (command, value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIntResult, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutIntResult))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIntResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(command), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Fcntl)

    // nn::Result AcceptStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcceptStart)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pWaitHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pWaitHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pTaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pTaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTaskId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWaitHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcceptStart)

    // nn::Result AcceptResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcceptResults)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOutSocket, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOutSocket))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(TaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (TaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutAddress, (::nn::htcs::SockAddrHtcs), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutAddress, pOutErrorCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSocket), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(TaskId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcceptResults)

    // nn::Result RecvStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t memorySize, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RecvStart)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pWaitHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pWaitHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(memorySize, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (memorySize, flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pTaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pTaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTaskId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWaitHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memorySize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RecvStart)

    // nn::Result RecvResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RecvResults)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(TaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (TaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReceivedSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutReceivedSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReceivedSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(TaskId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RecvResults)

    // nn::Result RecvLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t unalignedRecvSizeStart, std::int32_t unalignedRecvSizeEnd, std::int64_t alignedSendSize, nn::sf::NativeHandle&& alignedMemoryHandle, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RecvLargeStart)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(alignedMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (alignedMemoryHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pWaitHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pWaitHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(unalignedRecvSizeStart, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(unalignedRecvSizeEnd, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(alignedSendSize, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (unalignedRecvSizeStart, unalignedRecvSizeEnd, flags, alignedSendSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pTaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pTaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTaskId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWaitHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(unalignedRecvSizeStart), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(unalignedRecvSizeEnd), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alignedSendSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alignedMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RecvLargeStart)

    // nn::Result SendStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendStart)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pWaitHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pWaitHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (flags))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pTaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pTaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTaskId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWaitHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendStart)

    // nn::Result SendLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& startBuffer, const nn::sf::InBuffer& endBuffer, nn::sf::NativeHandle&& alignedMemoryHandle, std::int64_t alignedSendSize, std::int32_t flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendLargeStart)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(startBuffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(endBuffer, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (startBuffer, endBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(alignedMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (alignedMemoryHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pWaitHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pWaitHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(alignedSendSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (flags, alignedSendSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pTaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pTaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTaskId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pWaitHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(startBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(endBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alignedMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(alignedSendSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendLargeStart)

    // nn::Result SendResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendResults)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(TaskId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (TaskId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrorCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSentSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutErrorCode, pOutSentSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrorCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSentSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(TaskId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendResults)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::htcs::SockAddrHtcs), 66, 2)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::tma::ISocket, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::tma::ISocket))

    // nn::Result Close(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Close, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Close)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Close)
    }

    // nn::Result Connect(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result Bind(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, const nn::htcs::SockAddrHtcs& address) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Bind, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, const ::nn::htcs::SockAddrHtcs& address))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Bind)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(address)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Bind)
    }

    // nn::Result Listen(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t backlogCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Listen, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t backlogCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Listen)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(backlogCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Listen)
    }

    // nn::Result Accept(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Accept, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Accept)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSocket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Accept)
    }

    // nn::Result Recv(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Recv, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Recv)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReceivedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Recv)
    }

    // nn::Result Send(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Send, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Send)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSentSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Send)
    }

    // nn::Result Shutdown(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t how) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Shutdown, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t how))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Shutdown)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(how)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Shutdown)
    }

    // nn::Result Fcntl(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int32_t> pOutIntResult, std::int32_t command, std::int32_t value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Fcntl, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int32_t> pOutIntResult, ::std::int32_t command, ::std::int32_t value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Fcntl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIntResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(command)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Fcntl)
    }

    // nn::Result AcceptStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcceptStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTaskId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWaitHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcceptStart)
    }

    // nn::Result AcceptResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<nn::sf::SharedPointer<nn::tma::ISocket>> pOutSocket, nn::sf::Out<nn::htcs::SockAddrHtcs> pOutAddress, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::tma::ISocket>> pOutSocket, ::nn::sf::Out<::nn::htcs::SockAddrHtcs> pOutAddress, ::std::uint32_t TaskId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcceptResults)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSocket)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(TaskId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcceptResults)
    }

    // nn::Result RecvStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t memorySize, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t memorySize, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RecvStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTaskId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWaitHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memorySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RecvStart)
    }

    // nn::Result RecvResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutReceivedSize, const nn::sf::OutBuffer& buffer, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutReceivedSize, const ::nn::sf::OutBuffer& buffer, ::std::uint32_t TaskId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RecvResults)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReceivedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(TaskId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RecvResults)
    }

    // nn::Result RecvLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, std::int32_t unalignedRecvSizeStart, std::int32_t unalignedRecvSizeEnd, std::int64_t alignedSendSize, nn::sf::NativeHandle&& alignedMemoryHandle, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RecvLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, ::std::int32_t unalignedRecvSizeStart, ::std::int32_t unalignedRecvSizeEnd, ::std::int64_t alignedSendSize, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RecvLargeStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTaskId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWaitHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(unalignedRecvSizeStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(unalignedRecvSizeEnd)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alignedSendSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alignedMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RecvLargeStart)
    }

    // nn::Result SendStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& buffer, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& buffer, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTaskId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWaitHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendStart)
    }

    // nn::Result SendLargeStart(nn::sf::Out<std::uint32_t> pTaskId, nn::sf::Out<nn::sf::NativeHandle> pWaitHandle, const nn::sf::InBuffer& startBuffer, const nn::sf::InBuffer& endBuffer, nn::sf::NativeHandle&& alignedMemoryHandle, std::int64_t alignedSendSize, std::int32_t flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendLargeStart, (::nn::sf::Out<::std::uint32_t> pTaskId, ::nn::sf::Out<::nn::sf::NativeHandle> pWaitHandle, const ::nn::sf::InBuffer& startBuffer, const ::nn::sf::InBuffer& endBuffer, ::nn::sf::NativeHandle&& alignedMemoryHandle, ::std::int64_t alignedSendSize, ::std::int32_t flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendLargeStart)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTaskId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pWaitHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(startBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(endBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alignedMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(alignedSendSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendLargeStart)
    }

    // nn::Result SendResults(nn::sf::Out<std::int32_t> pOutErrorCode, nn::sf::Out<std::int64_t> pOutSentSize, std::uint32_t TaskId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendResults, (::nn::sf::Out<::std::int32_t> pOutErrorCode, ::nn::sf::Out<::std::int64_t> pOutSentSize, ::std::uint32_t TaskId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendResults)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSentSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(TaskId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendResults)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::tma::ISocket>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::tma::ISocket))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Close)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Bind)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(address)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Listen)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(backlogCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::tma::ISocket>), pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Accept)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutSocket),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutSocket, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Recv)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReceivedSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Send)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSentSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Shutdown)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(how)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Fcntl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIntResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(command),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcceptStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pWaitHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcceptStart)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pTaskId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pWaitHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcceptResults)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::tma::ISocket>), pOutSocket)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcceptResults)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOutSocket),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(TaskId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOutSocket, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RecvStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pWaitHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RecvStart)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pTaskId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pWaitHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(memorySize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RecvResults)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RecvResults)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReceivedSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(TaskId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RecvLargeStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(alignedMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pWaitHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RecvLargeStart)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pTaskId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pWaitHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(unalignedRecvSizeStart),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(unalignedRecvSizeEnd),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(alignedSendSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(alignedMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pWaitHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendStart)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pTaskId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pWaitHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendLargeStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(startBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(endBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(alignedMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pWaitHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendLargeStart)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pTaskId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pWaitHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(startBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(endBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(alignedMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(alignedSendSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendResults)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendResults)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrorCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSentSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(TaskId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Close)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Bind)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Listen)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Accept)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Recv)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Send)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Shutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Fcntl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcceptStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcceptResults)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RecvStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RecvResults)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RecvLargeStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendLargeStart)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendResults)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::tma::ISocket))
