﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace svc { namespace aarch64 {

struct ExceptionInfo
{
    Bit64   r[9];
    Bit64   lr;
    Bit64   sp;
    Bit64   pc;
    Bit32   pstate;
    Bit32   afsr0;
    Bit32   afsr1;
    Bit32   esr;
    Bit64   far;
};

struct ProcessLocalRegion
{
    Bit64           work[41];
    ExceptionInfo   info;
    Bit64           dyingMessageRegionAddress;
    Bit64           dyingMessageRegionSize;
    Bit64           reserved[6];
};

NN_STATIC_ASSERT(sizeof(ProcessLocalRegion) == 512);
}}}

