﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
/**
    @namespace nn::socket
    @brief socket related constants
*/
namespace nn     {
namespace socket {

/*
    Maximum number of messages for SendMMsg() and RecvMMsg()
*/
const int MaxNumMessages = 32;

/*
    Maximum size of each message for SendMMsg() and RecvMMsg()
*/
const int MaxMessageSize = 1500;

/*
    Maximum total size of combined messages allowed for SendMMsg() and RecvMMsg().
*/
const int MaxMessagesBytes = MaxNumMessages * MaxMessageSize;   // 48000

/*
    Definitions for network related sysctl, CTL_NET.

    Second level is protocol family.
    Third level is protocol number.

    Further levels are defined by the individual families below.
*/

/*
    Pf_Route - Routing table

    Three additional levels are defined:
    Fourth: address family, 0 is wildcard
    Fifth: type of info, defined below
    Sixth: flag(s) to mask with for NET_RT_FLAGS
*/
const int Net_Rt_Dump      = 1;    /* dump; may limit to a.f. */
const int Net_Rt_Flags     = 2;    /* by flags, e.g. RESOLVING */
const int Net_Rt_IfList    = 3;    /* survey interface list */
const int Net_Rt_IfMaList  = 4;    /* return multicast address list */
const int Net_Rt_IfListL   = 5;    /* Survey interface list, using 'l'en
                                             * versions of msghdr structs. */

}}
