﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/socket/sys/cdefs.h>

__BEGIN_DECLS

/* We need to link siglo and bsd style thread structures. */
typedef struct
{
    nn::os::ThreadType sigloThread;  /* actual siglo's ThreadType    */
    uint8_t bsdMetaData[256];        /* bsd related thread metadata  */
}
NetworkThread;

/* To have kernel pick cpu, set cpu to -1 */
int  CreateNetworkThread(NetworkThread* thread, void (*function)(void*), void* argument, void* stack, size_t stackSize, int priority, int cpu);
void StartNetworkThread(NetworkThread* thread);
void SetNetworkThreadNamePointer(NetworkThread* thread, const char* threadName);
void DestroyNetworkThread(NetworkThread* thread);
void WaitNetworkThread(NetworkThread* thread);
int* NetworkThreadErrno();

__END_DECLS


