﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace sf {

namespace detail {

    struct StatelessDummyAllocator;

}

// アロケーションポリシー作成用クラス
// { Stateless, Stateful } * { non-Typed, Typed } の 4 つ

/**
    @brief 状態を持たず型に依存しないアロケータを用いてサービスオブジェクトを構築するというアロケーションポリシーを表すクラステンプレートです。

    @deprecated このクラステンプレートを直接使用しないでください。今後、破壊的な仕様変更が入る可能性があります。

    @tparam Allocator 状態を持たないアロケータ型を指定します。
*/
template <class Allocator_>
class StatelessAllocationPolicy
{
public:

    static const bool HasStatefulAllocator = false;

    typedef detail::StatelessDummyAllocator Allocator;

    template <typename>
    struct GetAllocator
    {
        typedef Allocator_ type;
    };

    template <typename>
    static void* AllocateAligned(size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        return Allocator_().Allocate(size);
    }

    template <typename>
    static void DeallocateAligned(void* p, size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        Allocator_().Deallocate(p, size);
    }

};

/**
    @brief 状態を持たず型に依存するアロケータを用いてサービスオブジェクトを構築するというアロケーションポリシーを表すクラステンプレートです。

    @deprecated このクラステンプレートを直接使用しないでください。今後、破壊的な仕様変更が入る可能性があります。

    @tparam AllocatorT 型を取り、状態を持たないアロケータ型のテンプレートを指定します。
*/
template <template <typename T> class AllocatorT>
class StatelessTypedAllocationPolicy
{
public:

    static const bool HasStatefulAllocator = false;
    typedef detail::StatelessDummyAllocator Allocator;

    template <typename T>
    struct GetAllocator
    {
        typedef AllocatorT<T> type;
    };

    template <typename T>
    static void* AllocateAligned(size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        return AllocatorT<T>().Allocate(size);
    }

    template <typename T>
    static void DeallocateAligned(void* p, size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        AllocatorT<T>().Deallocate(p, size);
    }

};

/**
    @brief アロケータを用いてサービスオブジェクトを構築するというアロケーションポリシーを表すクラステンプレートです。

    @deprecated このクラステンプレートを直接使用しないでください。今後、破壊的な仕様変更が入る可能性があります。

    @tparam Allocator 状態を持つアロケータ型を指定します。
*/
template <class Allocator_>
class StatefulAllocationPolicy
{
public:

    static const bool HasStatefulAllocator = true;
    typedef Allocator_ Allocator;

    static void* AllocateAligned(Allocator* pAllocator, size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        return pAllocator->Allocate(size);
    }

    static void DeallocateAligned(Allocator* pAllocator, void* p, size_t size, size_t alignment) NN_NOEXCEPT
    {
        NN_UNUSED(alignment);
        pAllocator->Deallocate(p, size);
    }

};

}}
