﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// DFC 実装生成のために、自動生成系が使用するヘッダ・マクロ群
// マクロは NN_SF_IMPL_DETAIL_ 以下であり、フレームワーク実装外からの使用は不可

#include <nn/sf/detail/sf_CommonUtil.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>

#include <nn/sf/impl/detail/sf_ImplTemplateBase.h>

#define NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE(interfaceName) \
    namespace nn { namespace sf { namespace impl { namespace detail { \
    template <typename Base, typename ImplHolder, typename ImplGetter, typename RootInterface> \
    class ImplTemplateBaseT<NN_SF_DETAIL_STRIP_PAREN(interfaceName), Base, ImplHolder, ImplGetter, RootInterface> \
        : public Base, public ImplHolder \
    { \
    public: \
        template <typename... Args> \
        explicit ImplTemplateBaseT(Args&&... args) NN_NOEXCEPT \
            : ImplHolder{std::forward<Args>(args)...} \
        { \
        } \
    private:

#define NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE(interfaceName, baseName) \
    namespace nn { namespace sf { namespace impl { namespace detail { \
    template <typename Base, typename ImplHolder, typename ImplGetter, typename RootInterface> \
    class ImplTemplateBaseT<NN_SF_DETAIL_STRIP_PAREN(interfaceName), Base, ImplHolder, ImplGetter, RootInterface> \
        : public ImplTemplateBaseT<NN_SF_DETAIL_STRIP_PAREN(baseName), Base, ImplHolder, ImplGetter, RootInterface> \
    { \
    private: \
        typedef ImplTemplateBaseT<NN_SF_DETAIL_STRIP_PAREN(baseName), Base, ImplHolder, ImplGetter, RootInterface> _base; \
    public: \
        template <typename... Args> \
        explicit ImplTemplateBaseT(Args&&... args) NN_NOEXCEPT \
            : _base{std::forward<Args>(args)...} \
        { \
        } \
    private:

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, args) \
        virtual ::nn::Result NN_SF_DETAIL_SYNC_METHOD_NAME(name) args NN_NOEXCEPT NN_OVERRIDE

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(name) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, ())

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(name, args) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, args)

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(name) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, ())

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(name, args) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, args)

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(name, type) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, (::nn::sf::Out<NN_SF_DETAIL_STRIP_PAREN(type)> _pOut))

    #define NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(name, type, args) \
        NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_IMPL(name, (::nn::sf::Out<NN_SF_DETAIL_STRIP_PAREN(type)> _pOut, NN_SF_DETAIL_STRIP_PAREN(args)))

    #define NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, args) \
        (ImplGetter::GetImplPointer(static_cast<ImplHolder*>(this))->name args)

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(name) \
        NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, ()); \
        return ::nn::ResultSuccess()

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(name, args) \
        NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, args); \
        return ::nn::ResultSuccess()

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(name) \
        return NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, ())

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(name, args) \
        return NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, args)

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(name, type) \
        _pOut.Set(NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, ())); \
        return ::nn::ResultSuccess()

    #define NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(name, type, args) \
        _pOut.Set(NN_SF_IMPL_DETAIL_CALL_IMPL_METHOD(name, args)); \
        return ::nn::ResultSuccess()

#define NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END \
    }; \
    }}}}
