﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace sf { namespace cmif {

using InlineContext = Bit32;

InlineContext GetInlineContext() NN_NOEXCEPT;
InlineContext SetInlineContext(InlineContext x) NN_NOEXCEPT;

class ScopedInlineContextChanger
{
private:

    InlineContext m_SavedValue;

public:

    explicit ScopedInlineContextChanger(InlineContext newValue) NN_NOEXCEPT
        : m_SavedValue{SetInlineContext(newValue)}
    {
    }

    ~ScopedInlineContextChanger() NN_NOEXCEPT
    {
        SetInlineContext(m_SavedValue);
    }

};

}}}
