﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/client/detail/sf_CmifProxy.h>
#include <nn/sf/sf_ObjectImplFactory.h>

namespace nn { namespace sf { namespace cmif { namespace client {

// 自動生成される nn::sf::cmif::client::detail::CmifProxy<Interface, ProxyKind, AllocationPolicy> を使用して、
// 指定されたパラメータの Interface 実装を生成するためのファクトリクラス。
//
// テンプレート引数
// - typename Interface
//   - nn::sf:IServiceObject を継承したサービスインターフェイス
// - typename ProxyKind
//   - プロキシの種類を表す型
//   - 内部型として、以下を持つ
//     - typename ProxyBaseObject
//       - プロキシオブジェクトの元となるクラス
//       - CmifBaseObject を継承している必要がある
//       - 以下のメンバを持つ
//         - デフォルトコンストラクタ
//           - ObjectInfo と結び付けないでインスタンスを作成する
//           - この場合、後に ClientMessage::AttachOutObjects 内からアタッチされる
//         - ObjectInfo を引数にとれるコンストラクタ
//           - ObjectInfo は値であるが、これによって示されるオブジェクトの所有権を得る
//         - デストラクタ
//           - コンストラクタで与えられた ObjectInfo に対応する後処理を行う
//           - 何もアタッチされていない場合には何もしない
//     - typename ObjectInfo
//       - プロキシが対応するオブジェクトの識別子の型
//     - typename ClientMessage
//       - クライアントのメッセージを表す型
//       - 以下のメンバを持つ
//         - ProxyBaseObject* を引数にとれるコンストラクタ
//         - nn::sf::cmif::client::CmifClientMessage と同等の関数
// - typename AllocationPolicy
//   - アロケーション戦略を表す型
//   - nn::sf::ObjectImplFactory を参照
template <typename Interface, typename ProxyKind, typename AllocationPolicy>
class CmifProxyFactory
{
private:

    typedef detail::CmifProxy<Interface, ProxyKind, AllocationPolicy> Proxy;
    typedef typename ProxyKind::ProxyBaseObject ProxyBaseObject;
    typedef typename ProxyKind::ObjectInfo ObjectInfo;

    class ServiceObject
        : public Proxy
    {
    public:
        ServiceObject() NN_NOEXCEPT
        {
        }
        explicit ServiceObject(const typename ProxyKind::ObjectInfo& id) NN_NOEXCEPT
            : Proxy(id)
        {
        }
    };

    typedef nn::sf::ObjectImplFactory<ServiceObject, AllocationPolicy> ObjectImplFactory;
    typedef typename ObjectImplFactory::Allocator Allocator;

public:

    static Interface* CreateProxyObject() NN_NOEXCEPT
    {
        return ObjectImplFactory::Create();
    }

    static Interface* CreateProxyObject(Allocator* allocator) NN_NOEXCEPT
    {
        return ObjectImplFactory::Create(allocator);
    }

    static Interface* CreateProxyObject(const ObjectInfo& id) NN_NOEXCEPT
    {
        return ObjectImplFactory::Create(id);
    }

    static Interface* CreateProxyObject(Allocator* allocator, const ObjectInfo& id) NN_NOEXCEPT
    {
        return ObjectImplFactory::Create(allocator, id);
    }

    static Allocator* GetAllocator(Interface* p) NN_NOEXCEPT
    {
        return static_cast<typename ObjectImplFactory::Object*>(p)->GetAllocator();
    }

};

template <typename Interface, typename ProxyKind, typename AllocationPolicy = void>
class UnmanagedCmifProxy
     : public detail::CmifProxy<Interface, ProxyKind, AllocationPolicy>
{
private:

    typedef detail::CmifProxy<Interface, ProxyKind, AllocationPolicy> Base;

    virtual void AddReference() NN_NOEXCEPT NN_OVERRIDE
    {
        // nop
    }

    virtual void Release() NN_NOEXCEPT NN_OVERRIDE
    {
        // nop
    }

public:

    UnmanagedCmifProxy() NN_NOEXCEPT
    {
    }

    explicit UnmanagedCmifProxy(const typename ProxyKind::ObjectInfo& id) NN_NOEXCEPT
        : Base(id)
    {
    }

};

}}}}
