﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pinmux {

/**
* @brief 変更可能なピングループの名前
*
* @details NX spec の Pinmux ライブラリで変更可能なピングループの定義です。
*/
enum AssignablePinGroupName
{
    AssignablePinGroupName_ExtConUTx = 0, //!< EXTCON_U_TX
    AssignablePinGroupName_ExtConSTx = 1, //!< EXTCON_S_TX
    AssignablePinGroupName_Sdmmc1    = 2, //!< SDMMC1 (この GroupName を指定した場合 GetPinAssignment は使用できません。)
    AssignablePinGroupName_PwmFan    = 3, //!< PWM_FAN
};

/**
* @brief ピンアサインできる機能
*
* @details NX spec の Pinmux ライブラリでピンアサイン可能な定義です。
*/
enum PinAssignment
{
    PinAssignment_ExtConTxUart        = 0, //!< AssignablePinGroupName_ExtConUTx および AssignablePinGroupName_ExtConSTx に対して指定可能
    PinAssignment_ExtConTxGpio        = 1, //!< AssignablePinGroupName_ExtConUTx および AssignablePinGroupName_ExtConSTx に対して指定可能
    PinAssignment_Sdmmc1OutputHigh    = 2, //!< AssignablePinGroupName_Sdmmc1 に対して指定可能
    PinAssignment_Sdmmc1ResetState    = 3, //!< AssignablePinGroupName_Sdmmc1 に対して指定可能
    PinAssignment_Sdmmc1SchmtEnable   = 4, //!< AssignablePinGroupName_Sdmmc1 に対して指定可能
    PinAssignment_Sdmmc1SchmtDisable  = 5, //!< AssignablePinGroupName_Sdmmc1 に対して指定可能
    PinAssignment_PwmFanPwm           = 6, //!< AssignablePinGroupName_PwmFan に対して指定可能
    PinAssignment_PwmFanGpio          = 7, //!< AssignablePinGroupName_PwmFan に対して指定可能
};

} //gpio
} //nn
