﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Pinmux ライブラリの検査向けの設定変更機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/pinmux/pinmux_Api.h>
#include <nn/pinmux/pinmux_TypeForHardwareTest.h>

namespace nn {
namespace pinmux {

/**
 * @brief 検査向けに指定したピングループとのセッションをオープンします。
 *
 * @param[out]  pOutSession           ピングループごとのセッション用パラメータ
 * @param[in]   name                  アクセス対象のピングループの名前
 * @pre         ライブラリは初期化済みである。
 * @post        pOutSession に必要な情報が入力され、指定されたピングループがコントロール可能な状態になります。
 * @details     指定したピングループとのセッションをオープンします。アクセスするピングループごとにセッションをオープンをしてください。
 */
void OpenSessionForHardwareTest(PinmuxSession* pOutSession, AssignablePinGroupNameForHardwareTest name) NN_NOEXCEPT;

/**
 * @brief 検査向けに指定したピングループとのセッションをクローズします。
 *
 * @param[in]   pSession       ピングループごとのセッション用パラメータ
 * @pre         pSession がオープンされている。
 * @post        pSession で指定されたピングループとの通信を終了します。
 * @details     pSession で指定されたピングループとの通信を終了します。
 */
void CloseSessionForHardwareTest(PinmuxSession* pSession) NN_NOEXCEPT;

/**
 * @brief 検査向けにピングループの機能を設定します。
 *
 * @param[in]   pSession       ピングループごとのセッション用パラメータ
 * @param[in]   assignment     検査向けに設定したいピングループの機能
 * @pre         pSession がオープンされている。
 * @post        pSession で指定されたピングループが assingnment で指定された機能に設定されます。
 * @details     pSession で指定されたピングループが assingnment で指定された機能に設定されます。
 */
void SetPinAssignmentForHardwareTest(PinmuxSession* pSession, PinAssignmentForHardwareTest assignment) NN_NOEXCEPT;

} // pinmux
} // nn


