﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pinmux モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PINMUX_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PINMUX_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PINMUX_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PINMUX_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PINMUX_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PINMUX_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(pinmux, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PINMUX_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Trace, 0, format, args)
#define NN_DETAIL_PINMUX_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Trace, 1, format, args)
#define NN_DETAIL_PINMUX_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Trace, 2, format, args)
#define NN_DETAIL_PINMUX_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Trace, 3, format, args)

#define NN_DETAIL_PINMUX_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Info, 0, format, args)
#define NN_DETAIL_PINMUX_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Info, 1, format, args)
#define NN_DETAIL_PINMUX_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Info, 2, format, args)
#define NN_DETAIL_PINMUX_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Info, 3, format, args)

#define NN_DETAIL_PINMUX_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Warn, 0, format, args)
#define NN_DETAIL_PINMUX_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Warn, 1, format, args)
#define NN_DETAIL_PINMUX_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Warn, 2, format, args)
#define NN_DETAIL_PINMUX_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Warn, 3, format, args)

#define NN_DETAIL_PINMUX_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Error, 0, format, args)
#define NN_DETAIL_PINMUX_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Error, 1, format, args)
#define NN_DETAIL_PINMUX_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Error, 2, format, args)
#define NN_DETAIL_PINMUX_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Error, 3, format, args)

#define NN_DETAIL_PINMUX_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Fatal, 0, format, args)
#define NN_DETAIL_PINMUX_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Fatal, 1, format, args)
#define NN_DETAIL_PINMUX_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Fatal, 2, format, args)
#define NN_DETAIL_PINMUX_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(pinmux, Fatal, 3, format, args)

#define NN_DETAIL_PINMUX_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Trace, 0, text, length)
#define NN_DETAIL_PINMUX_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Trace, 1, text, length)
#define NN_DETAIL_PINMUX_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Trace, 2, text, length)
#define NN_DETAIL_PINMUX_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Trace, 3, text, length)

#define NN_DETAIL_PINMUX_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Info, 0, text, length)
#define NN_DETAIL_PINMUX_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Info, 1, text, length)
#define NN_DETAIL_PINMUX_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Info, 2, text, length)
#define NN_DETAIL_PINMUX_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Info, 3, text, length)

#define NN_DETAIL_PINMUX_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Warn, 0, text, length)
#define NN_DETAIL_PINMUX_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Warn, 1, text, length)
#define NN_DETAIL_PINMUX_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Warn, 2, text, length)
#define NN_DETAIL_PINMUX_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Warn, 3, text, length)

#define NN_DETAIL_PINMUX_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Error, 0, text, length)
#define NN_DETAIL_PINMUX_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Error, 1, text, length)
#define NN_DETAIL_PINMUX_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Error, 2, text, length)
#define NN_DETAIL_PINMUX_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Error, 3, text, length)

#define NN_DETAIL_PINMUX_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Fatal, 0, text, length)
#define NN_DETAIL_PINMUX_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Fatal, 1, text, length)
#define NN_DETAIL_PINMUX_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Fatal, 2, text, length)
#define NN_DETAIL_PINMUX_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(pinmux, Fatal, 3, text, length)
