﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief 通知ライブラリを開発で使用するための準備に使用する関数を提供します。
*/

#include <nn/nn_Common.h>
#include <nn/nn_Allocator.h>

namespace nn { namespace ovln {

//! @name 開発用初期化
//! @{

/**
    @brief (開発用) 一つのプログラム内で Sender と Receiver のやり取りをするものとして ovln ライブラリの初期設定を行います。

    @param[in] pMemoryResource アロケータを指定します。

    @pre PrepareSenderAndReceiverForDevelop() がまだ呼ばれていない。

    @details
     この API は開発用専用です。

     一つのプログラム内で Sender と Receiver のやり取りをするものとして ovln ライブラリの初期設定を行います。

     本関数は、nnMain() の初期や、それ以前に呼ばれることを想定しています。

     本関数による初期設定および今後の動作では pMemoryResource で指定されたアロケータが使用されます。
     pMemoryResource に nullptr を指定した際には、::operator new/delete が使用されます。
*/
void PrepareSenderAndReceiverForDevelop(MemoryResource* pMemoryResource = nullptr) NN_NOEXCEPT;

/**
    @brief (開発用) PrepareSenderAndReceiverForDevelop() で確保したリソースを解放します。

    @pre PrepareSenderAndReceiverForDevelop() によって初期設定が行われている。
    @pre Sender と Receiver ライブラリのすべての使用が完了している。

    @details
     この API は開発用専用です。

     PrepareSenderAndReceiverForDevelop() で確保したリソースを解放します。
     この間に使用された Sender ライブラリと Receiver ライブラリの仕様はすべて終わっている必要があります。

     必要がなければ、この関数を呼ばずにプログラムを終了して問題ないため、多くの場合には呼ばないことをお勧めします。
*/
void ReleasePreparedSenderAndReceiverForDevelop() NN_NOEXCEPT;

//! @}

}}
