﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Transfer memory 機能に関する型や定数の宣言
 */

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/os/os_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_SdkResult.h>

#include <nn/os/detail/os_MacroImpl.h>
#include <nn/os/detail/os_InternalCriticalSection.h>

namespace nn { namespace os {

//--------------------------------------------------------------------------
/**
 * @brief   TransferMemoryTypeオブジェクトを定義する構造体です。
 *
 * @details
 * メンバー変数を直接変更することは禁止です。 @n
 * 次の関数を介して、本構造体を利用してください。
 *
 * - @ref CreateTransferMemory()
 * - @ref DestroyTransferMemory()
 * - @ref AttachTransferMemory()
 * - @ref DetachTransferMemory()
 * - @ref MapTransferMemory()
 * - @ref UnmapTransferMemory()
 *
 * 上記の関数を利用するには nn/os/os_TransferMemory.h をインクルードする必要があります。
 *
 * nn::os::TransferMemory ユーティリティクラスもあわせてご確認ください。
 */
struct  TransferMemoryType
{
    enum State
    {
        State_Uninitialized     = 0,
        State_Created           = 1,
        State_Mapped            = 2,
        State_Detached          = 3,
    };

    uint8_t             _state;
    bool                _isHandleManaged;
    bool                _allocated;

    void*               _address;
    size_t              _size;
    NativeHandle        _handle;

    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;

    mutable detail::InternalCriticalSectionStorage  _csTransferMemory;
};

NN_OS_DETAIL_STATIC_ASSERT_TRIVIAL(TransferMemoryType);

//--------------------------------------------------------------------------

}} // namespace nn::os

