﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   共通メモリに関する型や定数の宣言
 */

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/os/os_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_SdkResult.h>

#include <nn/os/detail/os_MacroImpl.h>
#include <nn/os/detail/os_InternalCriticalSection.h>

namespace nn { namespace os {

//--------------------------------------------------------------------------
/**
 * @brief   共通メモリオブジェクトを定義する構造体です。
 *
 * @details
 * メンバー変数を直接変更することは禁止です。 @n
 * 次の関数を介して、本構造体を利用してください。
 *
 * - @ref CreateSharedMemory()
 * - @ref DestroySharedMemory()
 * - @ref AttachSharedMemory
 * - @ref MapSharedMemory()
 * - @ref UnmapSharedMemory()
 * - @ref GetSharedMemoryAddress()
 * - @ref GetSharedMemorySize()
 * - @ref GetSharedMemoryHandle()
 *
 * 上記の関数を利用するには nn/os/os_SharedMemory.h をインクルードする必要があります。
 *
 * nn::os::SharedMemory ユーティリティクラスもあわせてご確認ください。
 */
struct  SharedMemoryType
{
    enum State
    {
        State_NotInitialized    = 0,
        State_Initialized       = 1,
        State_Mapped            = 2,
    };

    uint8_t             _state;
    bool                _isHandleManaged;
    bool                _allocated;

    void*               _address;
    size_t              _size;
    NativeHandle        _handle;

    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;
    NN_OS_DETAIL_PADDING_POINTER;

    mutable detail::InternalCriticalSectionStorage  _csSharedMemory;
};

NN_OS_DETAIL_STATIC_ASSERT_TRIVIAL(SharedMemoryType);

//--------------------------------------------------------------------------

}} // namespace nn::os

