﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   仮想アドレスメモリ管理機能に関する API の宣言（システム向け）
 */

#pragma once

#include <nn/os.h>

namespace nn { namespace os {

//! @name 仮想アドレスメモリ管理機能に関する API の宣言（システム向け）
//! @{

//-----------------------------------------------------------------------------
/**
 * @brief   仮想アドレスメモリ関連機能を使用できるように初期化します
 *
 * @details
 *  仮想アドレスメモリ関連機能を使用できるようにライブラリを初期化します。
 *  本 API は nninitStartup() で一度だけ呼び出してください。
 *
 *  仮想アドレスメモリは許可されたプロセスでしか利用できません。
 *
 */
void InitializeVirtualAddressMemory() NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::os

