﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッド情報に関する型や定数の宣言
 */

#pragma once

#include <type_traits>
#include <nn/nn_Common.h>

namespace nn { namespace os {

//-----------------------------------------------------------------------------
/**
 * @brief   同一プロセッサで最後に動作したスレッドのコンテキストを保存する構造体です
 *
 */
struct  SdkLastThreadContext
{
#if defined(NN_BUILD_CONFIG_CPU_ARM64)
    Bit64 fp;  // r29
    Bit64 sp;  // sp
    Bit64 lr;  // r30
    Bit64 pc;  // pc
#else
    Bit32 fp;  // r11
    Bit32 sp;  // r13
    Bit32 lr;  // r14
    Bit32 pc;  // r15
#endif
};

//-----------------------------------------------------------------------------
/**
 * @brief   同一プロセッサで最後に動作したスレッドの状態を表す列挙体です
 *
 */
enum SdkLastThreadInfoFlag: Bit32
{
    LastThreadInfoFlag_ThreadInSystemCall = 0x00000001,
};

//-----------------------------------------------------------------------------

}} // namespace nn::os

