﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   システムプロセス用のスレッドに関する共通定義（SDK 内部用）
 */

#pragma once

//--------------------------------------------------------------------------

namespace nn { namespace os {

//--------------------------------------------------------------------------
//  システムプロセス用のスレッドの最高優先度を表す定数です。
const int   HighestSystemThreadPriority = -12;

//--------------------------------------------------------------------------
//  システムプロセス用のスレッドの最低優先度を表す定数です。
const int   LowestSystemThreadPriority  = 35;

//--------------------------------------------------------------------------

}} // namespace nn::os

